;-----------------------------------------------------------------------------
;
; DEMO PROGRAM 
;
; ECC4.BAS 
;
; for DS5000T, DS2250T
;
; Supported: Dallas Timekeeper parts DS5000T and DS2250T and their 
; ECC (embedded clock & calendar).
; The DS2250T and DS5000T are electrically identical, so this program is
; compatible with both.
; Not for use with DS2251/2 which have a different Timekeeper.
;
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
;		Systronix, Inc. Salt Lake City, Utah, USA
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;
; This shows the ECC with the BASIC RTC (choice 6, subr at 560)
; ONTIME with repeated ECC access is also demonstrated
;
;
; REVISION HISTORY -----------------------------------------------------------
;
;  02/16/94	BAB	Improved time output format with leading zeros if values
;				are less than 10.
;  02/02/93	BAB	Start


#target DS2250T
#code start 0H
#data start 6000H
#console mode=9600
#run trap local

unsigned char choice

100 ?: ?: gosub 550

200 INPUT "Set RUN<0>, AM/PM<1>, 12/24<2>, time<3>, write<4>, read<5>, reads <6>? ", choice
210 on choice gosub 500, 510, 520, 530, 540, 550, 560

230 goto 100


500 REM subr for run
502 Input "Run {0 or 1} ? ", choice : DS_ECC_RUN = choice
504 gosub 540
509 return

510 REM subr for am/pm
512 Input "AM/PM {0 or 1} ? ", choice : DS_AMPM = choice
514 gosub 540
519 return

520 REM subr for mode
522 Input "Mode {12 or 24} ? ", choice : DS_ECC_MODE = choice
524 gosub 540
529 return

530 REM subr for time
532 Input "Year ? ", choice : DS_YEAR = choice
533 Input "Month ? ", choice : DS_MONTH = choice
534 Input "Date ? ", choice : DS_DATE = choice
535 Input "Day of week ? ", choice : DS_DAY = choice
536 Input "Hour ? ", choice : DS_HOUR = choice
537 Input "Min ? ", choice : DS_MIN = choice
538 Input "Sec ? ", choice : DS_SEC = choice
539 gosub 540 : return

540 REM Subr Write
541 ?"Writing..." : DS_ECC_WR
549 return


550 REM Subr read
552 DS_ECC_RD
553	IF DS_MONTH < 10 then print "0",
    print DS_MONTH, "-",
    IF DS_DATE < 10 then print "0",
    print DS_DATE, "-", DS_YEAR, "  ",
    IF DS_HOUR < 10 then print "0",
    print DS_HOUR, ":",
    IF DS_MIN < 10 then print "0",
    print DS_MIN, ":",
    IF DS_SEC < 10 then print "0",
    print DS_SEC,".",
    IF DS_HSEC < 10 then print "0",
    print DS_HSEC
558 ? DS_ECC_MODE, " hour mode  RUN = ", DS_ECC_RUN, "  AM/PM = ",DS_AMPM
559 return

560 REM Continuous read
561 CLOCK0 : DS_ECC_RUN=0 : DS_ECC_WR 
562 TIME=DS_SEC : MSEC = DS_HSEC*10 : DS_ECC_RUN=1 : DS_ECC_WR
	: CLOCK1 : ONTIME TIME+10, 600
565 DS_ECC_RD
566 IF DS_HOUR < 10 then print "0",
    print DS_HOUR, ":",
    IF DS_MIN < 10 then print "0",
    print DS_MIN, ":",
    IF DS_SEC < 10 then print "0",
    print DS_SEC,".",
    IF DS_HSEC < 10 then print "0",
    print DS_HSEC,
	
568	? tab(15),"RTC TIME= ",TIME,":",MSEC,CR,
569 if get=0 then goto 565 else clock0 : return


600 REM Ontime routine
610 ? : ? "Ontime Routine!" : ?
620 ONTIME TIME+1, 600
699 RETI

999 END



