; Conditional assembly flags...
; These tell the assembler various compilation options
; Feel free to refer to these in your in-line assembly code
CODE_START EQU 51
DATA_START EQU 32768
CPRINT EQU 1	; serial print
SPRINT EQU 0	; serial print#
UPRINT EQU 0	; user print
UIO    EQU 0	; user i/o drivers
_ALIGN	SET 1	; 8 bit ptrs
PRINT_COMPLETE SET 0	; each print empties buffer
RTC EQU 1	; timer0 RTC
ONEX1 EQU 1	; enable ext int 1
ONTIME EQU 1	; enable
ARRAY EQU 0	; no array present   
ERR_MSG EQU 1	; err_msg is present
PUSH_POP EQU 0
READ_DATA EQU 0
ONERR EQU 0
PROGLINE SET 1	; track basic line numbers
RUN_TRAP_B52 EQU 0
RUN_TRAP_LOC EQU 1
SPMAX EQU 127
SPUSE_ONEX1 EQU 14	;actual stack space used
SPUSE_ONTIME EQU 20	;actual stack space used
SPUSE EQU 66	; actual istack max needed           
BASIC52 EQU 0
BEBASIC EQU 0
TARGET_8XC51F EQU 0
DS5000 EQU 2
ON_WARM SET 0
ON_POR SET 0
ON_RUNTRAP SET 0
ON_WDOG SET 0
ON_PWRFL SET 0
CHECK_ISTACK SET 0
CHECK_MATH SET 0
RELOC_VEC EQU 0
;_%%NO_B52_EQU:

_OPREG_0L 	EQU 0	
_OPREG_0H 	EQU 2
_OPREG_1L 	EQU 1
_OPREG_1H 	EQU 3
_OPREG_2L 	EQU 4
_OPREG_2H 	EQU 5
_R0 		EQU 0
_R1 		EQU 1
_R2 		EQU 2
_R3 		EQU 3
_R4 		EQU 4
_R5 		EQU 5
_R6 		EQU 6
_R7 		EQU 7


_NULLCNT	EQU 10H		
_PHEAD		EQU 11H		
_SPHEAD		EQU 12H		
_TREL1H		EQU 13H		
_TREL1L		EQU 14H
_SPCLEAR	EQU 15H		

_ASTACK_PTR_L	EQU 16H		
_ASTACK_PTR_H	EQU 17H		

	IF (UIO + UPRINT)
_UPHEAD		EQU 18H		
	ENDIF


_RTC_RELOAD	EQU 27H		
_RTC_MILLI	EQU 28H		
_RTC_SEC_LO	EQU 29H		
_RTC_SEC_HI	EQU 2AH		
_ONTIME_H	EQU 2BH		
_ONTIME_L	EQU 2CH		


	IF CPRINT
_CPRT_FLAG	BIT 21H.0	
_CPRT_RDY	BIT 21H.1	
	ENDIF

	IF SPRINT
_SPRT_FLAG	BIT 21H.2	
_SPRT_STOP	BIT 21H.3	
_SPRT_RDY	BIT 21H.4	
	ENDIF

	IF UPRINT
_UPRT_FLAG	BIT 21H.5	
	ENDIF

_ON_EX1		BIT 23H.1	
_ON_EX1_PND	BIT 23H.2	
_ON_EX1_INP	BIT 23H.3	

	IF UIO
_UIO_INP_FLAG	BIT 23H.6	
_UIO_OUT_FLAG	BIT 23H.4	
	ENDIF

_CNTRLS_FLAG	BIT 21H.6 	
_CNTRLC_FLAG	BIT 21H.7 	

_CLOCK_BIT	BIT 22H.0	
_ON_TIME	BIT 22H.1	
_ON_TIME_PND	BIT 22H.2	
_ON_TIME_INP	BIT 22H.3	

_ON_ERR		BIT 22H.4	
					  
_IDLE_END	BIT 22H.5	

_ASTACK_USED	BIT 22H.6	

_CPRT_INP	BIT 22H.7

_ES_FLAG	BIT 23H.0	

	IF DS5000
_WDOG_FLAG	BIT 23H.5	
	ENDIF

;_%%8031_EQU:

TARGET_8032	EQU 0		


;_%%GENERIC_EQU:

CR		EQU 13		
LF		EQU 10		
BS		EQU 8		
CNT_D		EQU 04   	
FPSIZE		EQU 6		


BSKEY		EQU 08H     	



ZERO_DIVIDE	EQU 10		
OVERFLOW	EQU 20		
UNDERFLOW	EQU 30		
BAD_ARGUMENT	EQU 40		

READ_OUT	EQU 50		
READ_TYPE	EQU 60		

ARRAY_INDEX	EQU 70		
STRING_TRUNC	EQU 80		

ONGO_EXPR	EQU 90		

ISTACK_ERR	EQU 100		

ASTACK_FULL	EQU 110		
ASTACK_EMPTY	EQU 120		
POP_TYPE	EQU 130		

MEM_ACC		EQU 140		
MEM_ACC_B52	EQU 150		

START_ERR	EQU 250		
;_%%DS5001_EQU:

MCON 	EQU 0C6H		
TA	EQU 0C7H		
RPCTL	EQU 0D8H		


_%%DS1283_EQU:

DS_83HSEC	EQU 00H		
DS_83SEC	EQU 01H		
DS_83MIN	EQU 02H		
DS_83MIN_AL	EQU 03H		
DS_83HOUR	EQU 04H
DS_83HOUR_AL	EQU 05H		
DS_83DAY	EQU 06H		
DS_83DAY_AL	EQU 07H		
DS_83DATE	EQU 08H		
DS_83MONTH	EQU 09H
DS_83YEAR	EQU 0AH		
DS_83CMD	EQU 0BH		
DS_83INTV_HSEC	EQU 0CH		
DS_83INTV_SEC	EQU 0DH		
DS_83DATE_AL	EQU 0EH		
DS_83MON_AL	EQU 0FH		

		    
;_%%SERIAL_IO_EQU:

_CNTRLQ		EQU 11H		
_CNTRLS		EQU 13H		
_CNTRLC		EQU 03H		

_INPLEN		EQU 80		

_FIFOLN		EQU 16		

 
_OUTLEN		EQU 80            

INPUT_ECHO	SET 1		

;_%%SYSTRONIX:

RXD 	BIT P3.0		
T0	BIT P3.4		
T1	BIT P3.5		

LP	BIT P1.7	

    IF TARGET_8032

TL2	EQU 0CCH		
TH2	EQU 0CDH
T2CON	EQU 0C8H		

    ENDIF


    IF TARGET_8XC51F

CH	EQU 0F9H		
CCAP0H	EQU 0FAH
CCAP1H	EQU 0FBH
CCAP2H	EQU 0FCH
CCAP3H	EQU 0FDH
CCAP4H	EQU 0FEH

CL	EQU 0E9H		
CCAP0L	EQU 0EAH
CCAP1L	EQU 0EBH
CCAP2L	EQU 0ECH
CCAP3L	EQU 0EDH
CCAP4L	EQU 0EEH

CCON	EQU 0D8H
CMOD	EQU 0D9H
CCAPM0	EQU 0DAH
CCAPM1	EQU 0DBH
CCAPM2	EQU 0DCH
CCAPM3	EQU 0DDH
CCAPM4	EQU 0DEH

SADEN	EQU 0B9H		
SADDR	EQU 0A9H		

IPH	EQU 0B7H		

    ENDIF

_START_VEC EQU 03H
	org		0000H		;code segment org

	ljmp		033H		;to user program start 51D

;_%%INT0B_GEN:


	org	_START_VEC+8
    IF BASIC52 EQ 0		       	
    	push	PSW			
    ENDIF				
	ljmp	_INT_RTC		
			       
;_%%INT13_GEN:

	org	_START_VEC+10H
    IF BASIC52 EQ 0		       	
    	push	PSW			
    ENDIF				
	ljmp	_INT13_DISPATCH		

;_%%INT23_GEN:

	org	_START_VEC+20H
    IF BASIC52 EQ 0		       	
    	push	PSW			
    ENDIF				
	ljmp	_INT23			

;_%%INT2B_DS5001:


	org	2BH
	push	PSW
	ljmp	_INT_PFW
	
	org		033H		;actual program start 51D

_START_LOC:		;main entry point when CALLed

_runtrap:		; run trap local iff no B52 interp

_START_NO_B52:
	clr	EA		

	clr	psw.4		
	clr	psw.3

	mov	21H, #0		
	mov	22H, #0
	mov	23H, #0		

	setb 	_IDLE_END	
	setb	TCON.2		

    IF SPRINT
	mov	_SPHEAD, #1	
    ENDIF
    	mov	R7, SP		

		mov	SP, #48		;set stack pointer
		mov	_SPCLEAR, SP		;save SP for CLEAR, etc
;_%%DS5_STARTUP1:
	push	PSW
	push	B
	push	ACC
	push	PCON			
	anl	MCON, #0FBH		
	anl	RPCTL, #0CDH		
	clr	IP.7			
	lcall	_DS5_WDOG_OFF		

		; INIT Real Time Clock
		; TH0 for RTC is 112D/70H
	mov _RTC_RELOAD, #112		; TH0 Reload value
	anl TCON, #0CFH		; clr TF0 and TR0
	anl TMOD, #0F0H		; setup timer0 for RTC
	lcall	_CLR_RTC		;clear RTC locations
CONSOLE_TIMER EQU 1
		; TH1 for 9600 baud is 250D/FAH
	mov R0, #250		; Reload value for 9600 baud
	lcall _SET_CBAUD_T1		;Setup Timer1 as baudgen
	lcall	_INIT_PRINT		;init print to serial i/o port 
	lcall	_INIT_GET		;init GET from serial i/o port 
_SERIAL_IO_INIT:
	CLR     _CNTRLS_FLAG	
	CLR     _CNTRLC_FLAG	
	clr	_CPRT_FLAG	
    IF BASIC52
	clr	23H.7		
    ENDIF

    IF SPRINT
 	clr	_SPRT_FLAG	
    ENDIF

	mov	SCON, #50H	
	SETB    ES		
	SETB    EA		


SERIAL_MODE SET 0
;_%%DS5_STARTUP2:

	mov 	A, PCON			
	pop	ACC			
	pop	_R0			
	pop	_R1			
	pop	PSW			

_DS_POR_WDCHK:				
	jnb	ACC.2, _DS_POR_PCHK	
	jnb	ACC.4, _DS_POR_PCHK	
    IF (ON_WDOG * DS5000)     	
	lcall	_DS_USER_WDOG		
    ENDIF				
	sjmp	_DS_POR_X		

_DS_POR_PCHK:				
	jb	ACC.6, _DS_POR_RCHK	
    IF (ON_POR * DS5000)		
	lcall	_DS_USER_POR		
    ENDIF				
	sjmp	_DS_POR_X		

_DS_POR_RCHK:				

_DS_POR_RT:				
    IF (RUN_TRAP_LOC * DS5000) 		
	jnb	F0, _DS_POR_WCHK	
	cjne	R0, #0AAH, _DS_POR_WCHK	
	cjne	R1, #055H, _DS_POR_WCHK	
      IF (ON_RUNTRAP)			
	lcall	_DS_USER_RTRAP		
      ENDIF				
	sjmp	_DS_POR_X		
    ENDIF				

_DS_POR_WCHK:				

	cjne 	R7, #07H, _DS_POR_ERR	

    IF (DS5000 * ON_WARM)		
	lcall	_DS_USER_WARM		
    ENDIF				
	sjmp	_DS_POR_X		

_DS_POR_ERR:				
    IF ERR_MSG
	mov	DPTR, #_bad_start	
    ENDIF
	mov	A, #START_ERR		
	ljmp	_ERR_HAND		

_DS_POR_X:
	mov	0C7H, #0AAH		
	mov	0C7H, #055H

    IF ON_PWRFL
    	orl	PCON, #048H		
    ELSE
	orl	PCON, #040H		
    ENDIF

; errline support
	lcall	_CLEAR_UVAR
;*****************************************************************************
; clear_expr
; This is a pretty exhaustive test program for the DS2251's on-board DS1283 
; clear_expr
; Timekeeper chip.  Menu options prompt you for all the tests.
; clear_expr
;
; clear_expr
; If you have a DS2251-128, set the K2 loader range to 128 and partition to 0.
; clear_expr
; If you have a smaller 2251, you may have to make other choices and/or move
; clear_expr
; the code start up to the partition address if you use a "2250-like"
; clear_expr
; partitioned memory map.
; clear_expr
;
; clear_expr
; Note that the #CHECK ISTACK configuration directive is disabled, since this
; clear_expr
; check is usually too conservative in programs which have all possible
; clear_expr
; interrupts active, on targets with only 128 bytes of internal RAM.  So we
; clear_expr
; have turned it off here, but be warned that there is then no way to check if
; clear_expr
; you ARE REALLY in danger of running out of stack space.
; clear_expr
;
; clear_expr
; If you use #PRINT COMPLETE OFF your program will use about 10 more bytes of
; clear_expr
; internal stack space than with PRINT COMPLETE ON (the default).  If the print
; clear_expr
; buffer ever fills completely, the processor can use up to 20 more bytes of
; clear_expr
; stack space as it waits for the buffer to empty.  One way to get the buffer
; clear_expr
; to fill is to send your target hardware a Control-S (X-OFF).  Printing a
; clear_expr
; lot of characters at a low baud rate will do it also.
; clear_expr
;
; clear_expr
; Avoid more than 2 sets of nested parentheses if (1) you are on a 128-byte
; clear_expr
; internal memory processor, (2) have all interrupts active and (3) print 
; clear_expr
; complete off. Break nested expressions into multiple statements separated 
; clear_expr
; by colons.
; clear_expr
;
; clear_expr
;
; clear_expr
; REVISION HISTORY -----------------------------------------------------------
; clear_expr
;
; clear_expr
;  03/29/94	BAB	Added AM/PM text display, improved status routine
; clear_expr
;
; clear_expr
;
; clear_expr
; DESIRED MODIFICATIONS ------------------------------------------------------
; clear_expr
;
; clear_expr
; NOTES AND COMMENTS ---------------------------------------------------------
; clear_expr
;
; clear_expr
; If you will be reading several different timekeeper values for example,
; clear_expr
; hours and minutes, there is a possibility that one could change while you
; clear_expr
; are reading the other.  For example if the time is 8:59 you could read the 
; clear_expr
; minutes as 59 and then they could roll over just before you read the hour
; clear_expr
; which would now be 9, so you'd get the time as 9:59 when it was really 9:00.
; clear_expr
;
; clear_expr
; To prevent this, just turn off DS83_UPDATE, read the values, and then turn 
; clear_expr
; update back on.  Remember update does not stop the timekeeper, it just
; clear_expr
; freezes its output register values.
; clear_expr
;
; clear_expr
;*****************************************************************************
; clear_expr
;-----------------------------------------------------------------------------
; clear_expr
; #TARGET DS2251T
; clear_expr
; #DATA START 8000H
; clear_expr
; #CODE START 0H
; clear_expr
; #CONSOLE MODE=9600
; clear_expr
; #RUN TRAP LOCAL
; clear_expr
; #PRINT COMPLETE OFF
; clear_expr
; #CHECK MATH OFF ; for RTC overflow to not cause math overflow
; clear_expr
; #CHECK ISTACK OFF ; too conservative for this program
; clear_expr
; UNSIGNED CHAR SPTR ; the stack pointer
; clear_expr
; UNSIGNED INT ADDR
; clear_expr
; UNSIGNED CHAR DAT, KEY, CHOICE, INTV_ALARM
; clear_expr
; UNSIGNED CHAR CHOICE1, CHOICE2, CHOICE3, CHOICE4, CHOICE5
; clear_expr
; clear_expr
; clear_expr
_B90:
	mov	R0, #90
	mov	R2, #0
	lcall	_LINE_DIAG
	lcall	_CLOCK_STOP
; clear_expr
; clear_expr
	lcall	_CLEAR_BASINTS
; clear_expr
; clear_expr
	setb	_CPRT_INP
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	lcall	_BSTATUS_PRINT
; clear_expr
; clear_expr
; clear_expr
_B92:
	mov	R0, #92
	mov	R2, #0
	lcall	_LINE_DIAG
_input1:
	mov	DPTR, #_str0
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana2
_offset2:
	mov	DPTR, #__CHOICE
	push	DPL
	push	DPH
	ljmp	_useit2
_scana2:
_scanb2:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token2
	lcall	_INP_WP
	ljmp	_scanb2
_token2:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input1
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset2
_useit2:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #6
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_ongo_a4
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_1H
	pop	_OPREG_1L
	ljmp	_ONGO_ERR2
_ongo_a4:
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IGE
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_ongo_b4
	pop	_OPREG_1H
	pop	_OPREG_1L
	ljmp	_ONGO_ERR1
_ongo_b4:
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_ongo_tbl4
	mov	R1, DPL
	mov	R3, DPH
	ljmp	_ONGO
; clear_expr
; clear_expr
; clear_expr
_B95:
	mov	R0, #95
	mov	R2, #0
	lcall	_LINE_DIAG
_input5:
	mov	DPTR, #_str1
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana6
_offset6:
	mov	DPTR, #__ADDR
	push	DPL
	push	DPH
	ljmp	_useit6
_scana6:
_scanb6:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token6
	lcall	_INP_WP
	ljmp	_scanb6
_token6:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UI
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input5
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset6
_useit6:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_B98
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_input8:
	mov	DPTR, #_str2
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana9
_offset9:
	mov	DPTR, #__DAT
	push	DPL
	push	DPH
	ljmp	_useit9
_scana9:
_scanb9:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token9
	lcall	_INP_WP
	ljmp	_scanb9
_token9:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input8
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset9
_useit9:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__ADDR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #__DAT
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	mov	R0, _OPREG_1L
	mov	R2, _OPREG_1H
	pop	_OPREG_1H
	pop	_OPREG_1L
	lcall	_DS_XBY_PE_SET
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_B98
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	ljmp	_B90
; clear_expr
; clear_expr
; clear_expr
_B98:
	mov	R0, #98
	mov	R2, #0
	lcall	_LINE_DIAG
	setb	_CPRT_INP
	mov	DPTR, #_str3
	lcall	_PRINT_ROM
	mov	DPTR, #__ADDR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_PH0
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str4
	lcall	_PRINT_ROM
	mov	DPTR, #__ADDR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	lcall	_DS_XBY_PE_GET
	push	_OPREG_0L
	push	_OPREG_0H
; subr for xby_pe display
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_PH0
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	ret
; clear_expr
; clear_expr
; clear_expr
_B100:
	mov	R0, #100
	mov	R2, #0
	lcall	_LINE_DIAG
	setb	_CPRT_INP
	mov	DPTR, #_str5
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_input11:
	mov	DPTR, #_str6
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana12
_offset12:
	mov	DPTR, #__CHOICE1
	push	DPL
	push	DPH
	ljmp	_useit12
_scana12:
_scanb12:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token12
	lcall	_INP_WP
	ljmp	_scanb12
_token12:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input11
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset12
_useit12:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE1
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_1224_WR
; clear_expr
; clear_expr
_if14:
	lcall  _DS83_1224_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else14
; clear_expr
; clear_expr
; clear_expr
_input15:
	mov	DPTR, #_str7
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana16
_offset16:
	mov	DPTR, #__CHOICE2
	push	DPL
	push	DPH
	ljmp	_useit16
_scana16:
_scanb16:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token16
	lcall	_INP_WP
	ljmp	_scanb16
_token16:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input15
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset16
_useit16:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE2
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_AMPM_WR
; clear_expr
; clear_expr
; clear_expr
_else14:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_B105:
	mov	R0, #105
	mov	R2, #0
	lcall	_LINE_DIAG
_input18:
	mov	DPTR, #_str8
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana19
_offset19:
	mov	DPTR, #__CHOICE1
	push	DPL
	push	DPH
	ljmp	_useit19
_scana19:
_scanb19:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token19
	lcall	_INP_WP
	ljmp	_scanb19
_token19:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input18
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset19
_useit19:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana21
_offset21:
	mov	DPTR, #__CHOICE2
	push	DPL
	push	DPH
	ljmp	_useit21
_scana21:
	mov	R0, #0
	mov	R2, #0
_scanb21:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token21
	lcall	_INP_WP
	ljmp	_scanb21
_token21:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input18
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset21
_useit21:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana23
_offset23:
	mov	DPTR, #__CHOICE3
	push	DPL
	push	DPH
	ljmp	_useit23
_scana23:
	mov	R0, #0
	mov	R2, #0
_scanb23:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token23
	lcall	_INP_WP
	ljmp	_scanb23
_token23:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input18
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset23
_useit23:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana25
_offset25:
	mov	DPTR, #__CHOICE4
	push	DPL
	push	DPH
	ljmp	_useit25
_scana25:
	mov	R0, #0
	mov	R2, #0
_scanb25:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token25
	lcall	_INP_WP
	ljmp	_scanb25
_token25:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input18
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset25
_useit25:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE1
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_HOUR_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE2
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_MIN_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE3
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_SEC_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE4
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_HSEC_WR
; clear_expr
; clear_expr
; clear_expr
_B109:
	mov	R0, #109
	mov	R2, #0
	lcall	_LINE_DIAG
	ljmp	_B90
; clear_expr
; clear_expr
; clear_expr
_B110:
	mov	R0, #110
	mov	R2, #0
	lcall	_LINE_DIAG
_input27:
	mov	DPTR, #_str9
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana28
_offset28:
	mov	DPTR, #__CHOICE2
	push	DPL
	push	DPH
	ljmp	_useit28
_scana28:
_scanb28:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token28
	lcall	_INP_WP
	ljmp	_scanb28
_token28:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input27
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset28
_useit28:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana30
_offset30:
	mov	DPTR, #__CHOICE3
	push	DPL
	push	DPH
	ljmp	_useit30
_scana30:
	mov	R0, #0
	mov	R2, #0
_scanb30:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token30
	lcall	_INP_WP
	ljmp	_scanb30
_token30:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input27
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset30
_useit30:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana32
_offset32:
	mov	DPTR, #__CHOICE4
	push	DPL
	push	DPH
	ljmp	_useit32
_scana32:
	mov	R0, #0
	mov	R2, #0
_scanb32:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token32
	lcall	_INP_WP
	ljmp	_scanb32
_token32:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input27
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset32
_useit32:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana34
_offset34:
	mov	DPTR, #__CHOICE5
	push	DPL
	push	DPH
	ljmp	_useit34
_scana34:
	mov	R0, #0
	mov	R2, #0
_scanb34:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token34
	lcall	_INP_WP
	ljmp	_scanb34
_token34:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input27
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset34
_useit34:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE2
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_MONTH_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE3
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_DATE_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE4
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_DAY_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE5
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_YEAR_WR
; clear_expr
; clear_expr
; clear_expr
_B119:
	mov	R0, #119
	mov	R2, #0
	lcall	_LINE_DIAG
	ljmp	_B90
; clear_expr
; clear_expr
; clear_expr
_B120:
	mov	R0, #120
	mov	R2, #0
	lcall	_LINE_DIAG
_input36:
	mov	DPTR, #_str10
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana37
_offset37:
	mov	DPTR, #__CHOICE1
	push	DPL
	push	DPH
	ljmp	_useit37
_scana37:
_scanb37:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token37
	lcall	_INP_WP
	ljmp	_scanb37
_token37:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input36
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset37
_useit37:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana39
_offset39:
	mov	DPTR, #__CHOICE2
	push	DPL
	push	DPH
	ljmp	_useit39
_scana39:
	mov	R0, #0
	mov	R2, #0
_scanb39:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token39
	lcall	_INP_WP
	ljmp	_scanb39
_token39:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input36
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset39
_useit39:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana41
_offset41:
	mov	DPTR, #__CHOICE3
	push	DPL
	push	DPH
	ljmp	_useit41
_scana41:
	mov	R0, #0
	mov	R2, #0
_scanb41:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token41
	lcall	_INP_WP
	ljmp	_scanb41
_token41:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input36
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset41
_useit41:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE1
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_RUN_WR
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE2
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_UPDATE_WR
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE3
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_SQW_WR
; clear_expr
; clear_expr
	ljmp	_B90
; clear_expr
; clear_expr
; clear_expr
_B200:
	mov	R0, #200
	mov	R2, #0
	lcall	_LINE_DIAG
; Continuously read the Timekeeper
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str11
	lcall	_PRINT_ROM
	lcall  _DS83_RUN_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str12
	lcall	_PRINT_ROM
	lcall  _DS83_UPDATE_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str13
	lcall	_PRINT_ROM
	lcall  _DS83_SQW_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str14
	lcall	_PRINT_ROM
	lcall  _DS83_CMD_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_PH0
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str15
	lcall	_PRINT_ROM
	lcall  _DS83_1224_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str16
	lcall	_PRINT_ROM
	lcall  _DS83_AMPM_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str17
	lcall	_PRINT_ROM
	lcall  _DS83_DAY_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_if43:
	mov	DPTR, #__INTV_ALARM
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else43
; clear_expr
	ljmp	_B201
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if43
_else43:
; clear_expr
	mov	DPTR, #_B700
	mov	R0, DPL
	mov	R2, DPH
	lcall	_ONEX1
_end_if43:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_B201:
	mov	R0, #201
	mov	R2, #0
	lcall	_LINE_DIAG
	lcall	_CLOCK_STOP
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	lcall  _DS83_UPDATE_WR
; clear_expr
; clear_expr
	lcall  _DS83_SEC_RD
	lcall	_TIME_SET
; clear_expr
; clear_expr
	lcall  _DS83_HSEC_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IMUL
	lcall	_MSEC_SET
; clear_expr
; clear_expr
	mov	R0, #1
	mov	R2, #0
	lcall  _DS83_UPDATE_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall	_CLOCK_START
; clear_expr
; clear_expr
	lcall	_TIME_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #10
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIADD
	mov	_ONTIME_H, R2		; high byte
	mov	_ONTIME_L, R0		; low byte
	mov	DPTR, #_B600
	mov	R0, DPL
	mov	R2, DPH
	lcall	_ONTIME
	setb	_ON_TIME		; ontime is active
; clear_expr
; clear_expr
; clear_expr
_B202:
	mov	R0, #202
	mov	R2, #0
	lcall	_LINE_DIAG
	mov	R0, #0
	mov	R2, #0
	lcall  _DS83_UPDATE_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	lcall  _DS83_MONTH_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str18
	lcall	_PRINT_ROM
	lcall  _DS83_DATE_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str19
	lcall	_PRINT_ROM
	lcall  _DS83_YEAR_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str20
	lcall	_PRINT_ROM
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
_B210:
	mov	R0, #210
	mov	R2, #0
	lcall	_LINE_DIAG
	setb	_CPRT_INP
	lcall  _DS83_HOUR_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str21
	lcall	_PRINT_ROM
	lcall  _DS83_MIN_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str22
	lcall	_PRINT_ROM
	lcall  _DS83_SEC_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str23
	lcall	_PRINT_ROM
	lcall  _DS83_HSEC_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str24
	lcall	_PRINT_ROM
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #1
	mov	R2, #0
	lcall  _DS83_UPDATE_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	R0, #22
	mov	R2, #0
	lcall	_TAB
	mov	DPTR, #_str25
	lcall	_PRINT_ROM
	lcall	_TIME_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_BTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str26
	lcall	_PRINT_ROM
	lcall	_MSEC_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_BTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov		A, #13
	lcall	_PUTC
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
_B230:
	mov	R0, #230
	mov	R2, #0
	lcall	_LINE_DIAG
	mov	DPTR, #__KEY
	push	DPL
	push	DPH
	lcall	_GET
	mov	_OPREG_0H,#00		;clear opreg0 upper byte
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
_if44:
	mov	DPTR, #__KEY
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IEQ
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else44
; clear_expr
	ljmp	_B202
; clear_expr
; advance w/any key press, else loop
_else44:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_B299:
	mov	R0, #43
	mov	R2, #1
	lcall	_LINE_DIAG
	ljmp	_B90
; clear_expr
; clear_expr
; clear_expr
_B300:
	mov	R0, #44
	mov	R2, #1
	lcall	_LINE_DIAG
; Alarm choices
; clear_expr
; clear_expr
; clear_expr
_B305:
	mov	R0, #49
	mov	R2, #1
	lcall	_LINE_DIAG
_input45:
	mov	DPTR, #_str27
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana46
_offset46:
	mov	DPTR, #__CHOICE
	push	DPL
	push	DPH
	ljmp	_useit46
_scana46:
_scanb46:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token46
	lcall	_INP_WP
	ljmp	_scanb46
_token46:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input45
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset46
_useit46:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #3
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_ongo_a48
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_1H
	pop	_OPREG_1L
	ljmp	_ONGO_ERR2
_ongo_a48:
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IGE
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_ongo_b48
	pop	_OPREG_1H
	pop	_OPREG_1L
	ljmp	_ONGO_ERR1
_ongo_b48:
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_ongo_tbl48
	mov	R1, DPL
	mov	R3, DPH
	ljmp	_ONGO
; clear_expr
; clear_expr
; clear_expr
_B310:
	mov	R0, #54
	mov	R2, #1
	lcall	_LINE_DIAG
; Disable
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; interval of 0 disables
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall  _DS83_INTV_HSEC_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; 
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall  _DS83_INTV_SEC_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__INTV_ALARM
	push	DPL
	push	DPH
	mov	R0, #0
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str28
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	ljmp	_B90
; clear_expr
; Tie INTB output from DS2251 to its ONEX1 input for this test:
; clear_expr
; clear_expr
; clear_expr
_B320:
	mov	R0, #64
	mov	R2, #1
	lcall	_LINE_DIAG
	mov	R0, #208
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; intB = interval pulsed low
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall  _DS83_CMD_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	R0, TCON
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #64
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; onex1 is falling edge sensitive
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	mov	TCON, R0
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_input49:
	mov	DPTR, #_str29
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana50
_offset50:
	mov	DPTR, #__CHOICE1
	push	DPL
	push	DPH
	ljmp	_useit50
_scana50:
_scanb50:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token50
	lcall	_INP_WP
	ljmp	_scanb50
_token50:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input49
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset50
_useit50:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana52
_offset52:
	mov	DPTR, #__CHOICE2
	push	DPL
	push	DPH
	ljmp	_useit52
_scana52:
	mov	R0, #0
	mov	R2, #0
_scanb52:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token52
	lcall	_INP_WP
	ljmp	_scanb52
_token52:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input49
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset52
_useit52:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
; set up interval
	mov	DPTR, #__CHOICE1
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_INTV_SEC_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE2
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_INTV_HSEC_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__INTV_ALARM
	push	DPL
	push	DPH
	mov	R0, #1
	mov	R2, #0
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str30
	lcall	_PRINT_ROM
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	lcall  _DS83_INTV_SEC_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str31
	lcall	_PRINT_ROM
	lcall  _DS83_INTV_HSEC_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str32
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
_B359:
	mov	R0, #103
	mov	R2, #1
	lcall	_LINE_DIAG
	ljmp	_B90
; clear_expr
; clear_expr
; clear_expr
_B370:
	mov	R0, #114
	mov	R2, #1
	lcall	_LINE_DIAG
; Time of day alarm options
; clear_expr
; clear_expr
; clear_expr
_B371:
	mov	R0, #115
	mov	R2, #1
	lcall	_LINE_DIAG
_input54:
	mov	DPTR, #_str33
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana55
_offset55:
	mov	DPTR, #__CHOICE
	push	DPL
	push	DPH
	ljmp	_useit55
_scana55:
_scanb55:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token55
	lcall	_INP_WP
	ljmp	_scanb55
_token55:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input54
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset55
_useit55:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #2
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_ILT
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_ongo_a57
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_1H
	pop	_OPREG_1L
	ljmp	_ONGO_ERR2
_ongo_a57:
	mov	R0, #0
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_IGE
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_ongo_b57
	pop	_OPREG_1H
	pop	_OPREG_1L
	ljmp	_ONGO_ERR1
_ongo_b57:
	pop	_OPREG_0H
	pop	_OPREG_0L
	mov	DPTR, #_ongo_tbl57
	mov	R1, DPL
	mov	R3, DPH
	ljmp	_ONGO
; clear_expr
; clear_expr
; clear_expr
_B380:
	mov	R0, #124
	mov	R2, #1
	lcall	_LINE_DIAG
; Disable TOD alarm
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall  _DS83_CMD_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #4
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; set TOD mask bit to disable
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_COR
	lcall  _DS83_CMD_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str34
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	ljmp	_B90
; clear_expr
; clear_expr
; clear_expr
_B390:
	mov	R0, #134
	mov	R2, #1
	lcall	_LINE_DIAG
; Enable TOD alarm
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	lcall  _DS83_CMD_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #248
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
; clr TOD mask bit to enable
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_CAND
	lcall  _DS83_CMD_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_input58:
	mov	DPTR, #_str35
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana59
_offset59:
	mov	DPTR, #__CHOICE1
	push	DPL
	push	DPH
	ljmp	_useit59
_scana59:
_scanb59:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token59
	lcall	_INP_WP
	ljmp	_scanb59
_token59:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input58
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset59
_useit59:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana61
_offset61:
	mov	DPTR, #__CHOICE2
	push	DPL
	push	DPH
	ljmp	_useit61
_scana61:
	mov	R0, #0
	mov	R2, #0
_scanb61:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token61
	lcall	_INP_WP
	ljmp	_scanb61
_token61:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input58
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset61
_useit61:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
	ljmp	_scana63
_offset63:
	mov	DPTR, #__CHOICE3
	push	DPL
	push	DPH
	ljmp	_useit63
_scana63:
	mov	R0, #0
	mov	R2, #0
_scanb63:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token63
	lcall	_INP_WP
	ljmp	_scanb63
_token63:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input58
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset63
_useit63:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE1
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_DAY_AL_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE2
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_HOUR_AL_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE3
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_MIN_AL_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_input65:
	mov	DPTR, #_str36
	lcall	_PRINT_ROM
	lcall	_INP_NP
	ljmp	_scana66
_offset66:
	mov	DPTR, #__CHOICE
	push	DPL
	push	DPH
	ljmp	_useit66
_scana66:
_scanb66:
	lcall	_STR_TOK
	mov	A, R0
	orl	A, R2
	jz	$+5
	ljmp	_token66
	lcall	_INP_WP
	ljmp	_scanb66
_token66:
	mov	DPTR, #_STR_TOK_CUR
	movx	A, @DPTR
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR
	mov	R2, A
	lcall	_ATOI
	lcall	_CHECK_UC
	jnb	F0, $+6		; no flag so jump ahead
	ljmp	_input65
	push	_OPREG_0L
	push	_OPREG_0H
	ljmp	_offset66
_useit66:
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	push	_OPREG_1L
	push	_OPREG_1H
	pop	DPH
	pop	DPL
	mov	A, R0
	movx	@DPTR, A
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	mov	DPTR, #__CHOICE
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	lcall  _DS83_MASK_AL_WR
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str37
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
_B395:
	mov	R0, #139
	mov	R2, #1
	lcall	_LINE_DIAG
	setb	_CPRT_INP
	mov	DPTR, #_str38
	lcall	_PRINT_ROM
	lcall  _DS83_DAY_AL_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str39
	lcall	_PRINT_ROM
	lcall  _DS83_HOUR_AL_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str40
	lcall	_PRINT_ROM
	lcall  _DS83_MIN_AL_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str41
	lcall	_PRINT_ROM
	lcall  _DS83_MASK_AL_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
_B399:
	mov	R0, #143
	mov	R2, #1
	lcall	_LINE_DIAG
	ljmp	_B90
; clear_expr
; clear_expr
; clear_expr
_B600:
	mov	R0, #88
	mov	R2, #2
	lcall	_LINE_DIAG
; Ontime routine
; clear_expr
; #ASM
; clear_expr


	lcall _SPTR
; #ASM_END
; clear_expr
; clear_expr
_B610:
	mov	R0, #98
	mov	R2, #2
	lcall	_LINE_DIAG
	setb	_CPRT_INP
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str42
	lcall	_PRINT_ROM
	mov	DPTR, #__SPTR
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
_B620:
	mov	R0, #108
	mov	R2, #2
	lcall	_LINE_DIAG
	lcall	_TIME_GET
	push	_OPREG_0L
	push	_OPREG_0H
	mov	R0, #1
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	pop	_OPREG_1H
	pop	_OPREG_1L
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UIADD
	mov	_ONTIME_H, R2		; high byte
	mov	_ONTIME_L, R0		; low byte
	mov	DPTR, #_B600
	mov	R0, DPL
	mov	R2, DPH
	lcall	_ONTIME
	setb	_ON_TIME		; ontime is active
; clear_expr
; clear_expr
; clear_expr
_B699:
	mov	R0, #187
	mov	R2, #2
	lcall	_LINE_DIAG
	ljmp	_RETI_BAS
; clear_expr
; clear_expr
; clear_expr
_B700:
	mov	R0, #188
	mov	R2, #2
	lcall	_LINE_DIAG
; Onex1 routine
; clear_expr
; #ASM
; clear_expr


	lcall _SPTR
; #ASM_END
; clear_expr
; clear_expr
_B710:
	mov	R0, #198
	mov	R2, #2
	lcall	_LINE_DIAG
	setb	_CPRT_INP
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str43
	lcall	_PRINT_ROM
	mov	DPTR, #__SPTR
	movx	A, @DPTR
	mov	R0, A
	mov	R2, #0
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
_B799:
	mov	R0, #31
	mov	R2, #3
	lcall	_LINE_DIAG
	ljmp	_RETI_BAS
; clear_expr
; clear_expr
; clear_expr
_B998:
	mov	R0, #230
	mov	R2, #3
	lcall	_LINE_DIAG
; clear_expr
; #ASM
; clear_expr


	; written to help catch istack errors
	; saves max value of SP in the BASIC var SPTR
_SPTR:
	mov DPTR, #__SPTR	; point to BASIC var SPTR
	movx A, @DPTR		; current SPTR value
	cjne	A, SP, _SP2	; C set if A < SP
_SP2:
	jnc _SPX		; jmp if current SPTR is >= SP
	mov A, SP		; else get current SP value
	movx @DPTR, A		; save in variable location
_SPX:
	ret
; #ASM_END
; clear_expr
; clear_expr
_B999:
	mov	R0, #231
	mov	R2, #3
	lcall	_LINE_DIAG
; BASIC END (subroutines may follow)
	ljmp	_end_module
; clear_expr
; clear_expr
; clear_expr
_BSTATUS_PRINT:
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str44
	lcall	_PRINT_ROM
	lcall  _DS83_RUN_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str45
	lcall	_PRINT_ROM
	lcall  _DS83_UPDATE_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str46
	lcall	_PRINT_ROM
	lcall  _DS83_SQW_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str47
	lcall	_PRINT_ROM
	lcall  _DS83_1224_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str48
	lcall	_PRINT_ROM
	lcall  _DS83_AMPM_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	setb	_CPRT_INP
	lcall  _DS83_MONTH_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str49
	lcall	_PRINT_ROM
	lcall  _DS83_DATE_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str50
	lcall	_PRINT_ROM
	lcall  _DS83_YEAR_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str51
	lcall	_PRINT_ROM
	lcall  _DS83_DAY_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str52
	lcall	_PRINT_ROM
	lcall	_PRINT_REST
; clear_expr
; clear_expr
	setb	_CPRT_INP
	lcall  _DS83_HOUR_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str53
	lcall	_PRINT_ROM
	lcall  _DS83_MIN_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str54
	lcall	_PRINT_ROM
	lcall  _DS83_SEC_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	mov	DPTR, #_str55
	lcall	_PRINT_ROM
	lcall  _DS83_HSEC_RD
	push	_OPREG_0L
	push	_OPREG_0H
	mov	DPTR, #_pbuffer
	mov	R1, DPL
	mov	R3, DPH
	pop	_OPREG_0H
	pop	_OPREG_0L
	lcall	_UCTOA
	mov	DPTR, #_pbuffer
	lcall	_PRINT
	lcall	_PRINT_REST
; clear_expr
; clear_expr
_if68:
	lcall  _DS83_1224_RD
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else68
; clear_expr
; clear_expr
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str56
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
; clear_expr
; clear_expr
	ljmp	_end_if68
_else68:
; clear_expr
; clear_expr
; clear_expr
; if not 24 hour mode, then ampm bit is significant
; clear_expr
; clear_expr
_if69:
	lcall  _DS83_AMPM_RD
	mov	A, R0
	orl	A, R2
	jnz	$+5
	ljmp	_else69
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str57
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
; clear_expr
	ljmp	_end_if69
_else69:
; clear_expr
	setb	_CPRT_INP
	mov	DPTR, #_str58
	lcall	_PRINT_ROM
	lcall	_PUT_NEW_LINE
	lcall	_PRINT_REST
_end_if69:
; clear_expr
; clear_expr
; clear_expr
; clear_expr
_end_if68:
; clear_expr
; clear_expr
; clear_expr
	ret
; clear_expr
_INT_PFW:
    IF ON_PWRFL
	lcall	_DS_USER_PWRFL		
    ENDIF





    

_INT_PFW2:
	mov 	ACC, PCON	 	
	jb	ACC.5, _INT_PFW2 	

	pop	PSW  			
	pop	ACC		
	pop	ACC			

    	setb	F0			
	mov	A, #0AAH		
	mov	B, #055H		

	mov	DPTR, #_runtrap
	push	DPL
	push	DPH	       		
	reti				

_SET_CBAUD_T1:
	anl	TCON, #3Fh	
    IF TARGET_8032
	anl	T2CON, #0CFh	
    ENDIF
	anl	TMOD, #2Fh	
	orl	TMOD, #20h	
	orl	PCON, #80h	
	mov	TH1, R0		
	mov	TL1, #0		
	setb	TR1		
	ret

;_%%DS5_WATCHDOG:

_DS5_WDOG_RST:
	mov	0C7H, #0AAH	
	mov	0C7H, #055H
	setb	IP.7		
	ret

_DS5_WDOG_ON:
	lcall	_DS5_WDOG_RST	
	mov	0C7H, #0AAH	
	mov	0C7H, #055H
	orl	PCON, #004H	
	setb	_WDOG_FLAG	
	ret

_DS5_WDOG_OFF:
	mov	0C7H, #0AAH	
	mov	0C7H, #055H
	anl	PCON, #0FBH	
	clr	_WDOG_FLAG	
	ret

_CLEAR_UVAR:	; clear user variables (if any) in external data RAM
	mov	DPTR, #_udataend
	mov	R2, DPH
	mov	R0, DPL
	mov	DPTR, #_udatabeg
	sjmp	_CLEAR1

_CLEAR:
	mov	A, DPL		; add count to the starting address to get a ... 
	add	A, R0		; ... terminal address
	mov	R0, A
	mov	A, DPH
	addc	A, R2
	mov	R2, A
	sjmp	_CLEAR1

	
_CLEARIT:
	clr	A 		; this is the zero that we will write
	movx	@DPTR, A	; write the byte
	inc	DPTR		; point to next byte but don't clear it yet

_CLEAR1:
	mov	A, R0		; compare current count with terminal count
	xrl	A, DPL		; low bytes first
	jnz	_CLEARIT	;
	
	mov	A, R2		; compare the high bytes if the low bytes are the same
	xrl	A, DPH
	jnz	_CLEARIT
	ret    			; reached the terminus so we're done

_INT_PUT:
	mov	A, R0		; get the low byte in the accumulator
	movx	@DPTR, A	; put the byte
 	inc	DPTR		; point to high byte
	mov	A, R2		; get the high byte in the accumulator
	movx	@DPTR, A	; put the byte
	ret			; done

_LINE_DIAG:

	IF DS5000
		mov 	ACC, PCON	 	; check PFW flag PCON.5
		jb	ACC.5, _LINE_DIAGX 	; if PFW int, leave now!
	ENDIF

	IF PROGLINE
		mov dptr, #_BASLINE
		lcall _INT_PUT
	ENDIF

	IF CHECK_ISTACK
		lcall _ISTACK_CHECK
	ENDIF

_LINE_DIAGX:
	ret

_CLOCK_STOP:
	CLR		_CLOCK_BIT		; clr clock active flag

 ;********************************
 ;********************************
	
 	CLR		ET0			; stop timer 0
_CLOCK_STOPX:
	ret

_ONTIME:

	mov	DPTR, #_INT_0B_LOC	; get the address of _INT_0B_LOC
	mov	A, R0  			; save low byte of handler address
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2	  		; save high byte of handler address
	movx	@DPTR, A
	orl	IE, #82H  		; enable timer 0 overflow interupt
	ret		   		; done

;_%%INT_0B_13:			

  IF ONEX1
_INT13_DISPATCH:			; the ONEX1 handler entry point
	jnb	_ON_EX1, _INT13_DISX	; exit if onex1 instruction not active

  ;********************************
    IF SPRINT				; print#
      	jnb	_SPRT_FLAG, _INT13_SX	; continue if print# not in progress
    	setb	_ON_EX1_PND		; set pend flag for print# use
    	pop	psw			; ret (not reti) to print# in progress
    	ret				; this disables further onex1 interrupts and leaves
					; TCON.3 cleared by call to vector 13H
_INT13_SX:
    ENDIF
  ;********************************


  ;********************************
    IF (CPRINT * PRINT_COMPLETE)	; 6/30/92 to enable ONEX1 while serial I/O
	jnb	_CPRT_INP, _INT13_CX
    	setb	_ON_EX1_PND		; set pend flag for print use
    	pop	psw			; ret (not reti) to print in progress
    	ret				; this disables further onex1 interrupts and leaves
_INT13_CX:
    ENDIF
  ;********************************

    IF (CPRINT * PRINT_COMPLETE)	; ...still need this w/cprt_inp.
	jb	_CPRT_FLAG, $		; print in progress, finish it
    ENDIF				; cprt_inp can be clear but buff still
    					; outputting characters.  We shouldn't
					; care - we can add to those in the
					; buffer if we print in onex1???

	push	DPL			; onex1 instr active so proceed
	push	DPH
	mov	DPTR, #_INT_13_LOC	; get current handler addr
	clr	F0		; means this was NOT the ontime handler, is onex1 instead
	setb	_ON_EX1_INP		; set in progress flag
	clr	_ON_EX1_PND		; clear pend flag
	push	PSW			; to save the F0 flag

	sjmp	_INT_DISPATCH

_INT13_DISX:				; exit with no handler actions
	pop		PSW		; onex1 not active so return 
	reti				

  ENDIF					; endif onex1



  IF RTC

_INT0B_PND_DISP:			; pending ontime entry point
	push	DPL			; save dptr and...
	push	DPH			; ...fall through to rest of int0b

_INT_0B_DISPATCH:			; the RTC handler entry point
	mov	DPTR, #_INT_0B_LOC	; get current handler addr
	setb	F0			; means this was ontime handler
	push	PSW			; to save the F0 flag 

  ENDIF

_INT_DISPATCH:
	push	ACC
	push	B
	push	_R0
	push	_R1
	push	_R2
	push	_R3
	push	_R4
	push	_R5
	push	_R6
	push	_R7	  

	setb	_IDLE_END		; set the flag to terminate IDLE mode

	movx	A, @DPTR		; low byte
	mov	R0, A
	inc	DPTR
	movx	A, @DPTR		; high byte
	mov	DPH, A	   		; load the DPTR with the address of the handler
	mov	DPL, _R0
	clr	A
	jmp	@A+DPTR			; go do the routine

_INT_RTC:

 	jnb	_CLOCK_BIT, _INT_RTC_XX		; real time clock not enabled so quit

	push	ACC				; save accumulator

	mov	TH0, _RTC_RELOAD		; reLOAD THE TIMER
	mov	A, _RTC_MILLI			; GET MILLISECOND COUNTER
	inc	A				; BUMP COUNTER
	cjne	A, #200, _INT_RTC_1		; jump if no need to inc seconds counters
	clr	A				; otherwise FORCE ACC TO BE ZERO
	inc	_RTC_SEC_LO			; INCREMENT LOW TIMER
	cjne	A, _RTC_SEC_LO, _INT_RTC_1	; CHECK LOW VALUE, if 0 it rolled over
	inc	_RTC_SEC_HI			; ...so incr TIMER HIGH byte

_INT_RTC_1:
	mov	_RTC_MILLI, A			; save new millisec value

 
	jnb	_ON_TIME, _INT_RTC_X		; ONTIME not executed so leave

	jb 	_ON_TIME_INP, _INT_RTC_X	; another ONTIME in progress?
						; ...if so, try again later

	jb 	_ON_TIME_PND, _INT_RTC_YES	; ONTIME previously compared?

						; see if time >= ontime value
	mov	A, _ONTIME_H	  	     	; check high byte
	cjne	A, _RTC_SEC_HI, _INT_RTC_NE  	; C set if rtc_h > ontime_h
						; if here, H were ==
	mov	A, _ONTIME_L 	   	     	; get low byte
	cjne	A, _RTC_SEC_LO, _INT_RTC_NE  	; C set if rtc_l > ontime_l
						; if here, both were ==
	sjmp	_INT_RTC_YES   			; ...so go do the ontime

_INT_RTC_NE:					; not ==, could be >
	jnc	_INT_RTC_X			; rtc not >= ontime so leave

_INT_RTC_YES:					; rtc >= ontime

 ;********************************
    IF SPRINT
	jb	_SPRT_FLAG, _INT_RTC_PX		; sprt in progress, try later
    ENDIF
  ;********************************

  ;********************************
    IF CPRINT
	jb	_CPRT_INP, _INT_RTC_PX		; cprt in progress, try later
    	IF PRINT_COMPLETE
	    jb	_CPRT_FLAG, _INT_RTC_PX		; complete the print first
	ENDIF
    ENDIF
  ;********************************

  ;********************************
    IF DS5000 
    	mov	A, MCON
	jb	ACC.2, _INT_RTC_PX		; if ECE2/PES set, leave
    ENDIF					; ...do ontime later

    IF (DS5000 EQ 2)
	jb	RPCTL.5, _INT_RTC_PX		; if EXBS set, leave
    ENDIF					; ...do ontime later
  ;********************************

	pop	ACC				; restore acc before dptr push
	setb	_ON_TIME_INP			; ontime now in progress 
	clr	_ON_TIME_PND			; ontime no longer waiting
	clr	_ON_TIME			; ontime no longer current
	push	DPL				; save current DPTR
	push	DPH
	mov	DPTR, #_INT_RTC_J
	push	DPL			 	; push label we want to go to
	push	DPH
	reti					; pop label->PC and enable RTC interrupts

_INT_RTC_J:					; jump and never return...
	ljmp	_INT_0B_DISPATCH		; ...jump to ontime dispatcher

_INT_RTC_PX:					; if here, exit w/ pnd flag
	setb	_ON_TIME_PND			; ontime waiting to be handled

_INT_RTC_X:					; if here, exit w/o pnd flag
	pop	ACC		       		; restore accumulator

_INT_RTC_XX:
 	pop	PSW		       		; restore PSW from vector push
	reti

_CLR_RTC:
	clr 	A
	mov 	_RTC_SEC_LO, A		; clear RTC time values
	mov 	_RTC_SEC_HI, A
	mov 	_RTC_MILLI, A
	mov 	_ONTIME_L, A		; clear ONTIME {time comparison value}
	mov 	_ONTIME_H, A
_CLR_RTC_FLAGS:
	clr 	_ON_TIME	      	; clear "ONTIME active" flag bit
	clr 	_ON_TIME_PND 		; clear "ONTIME pending" flag bit
	clr 	_ON_TIME_INP 		; clear "ONTIME in process" flag bit
 	ret

_CLEAR_BASINTS:
	clr 	_ON_TIME		; clear "ONTIME active" flag bit
	clr 	_ON_TIME_INP 	 	; clear ONTIME in progress flag bit
	clr 	_ON_TIME_PND 	 	; clear ONTIME pending flag bit

	clr 	_ON_EX1			; clear "ONEX1 active" flag bit
	clr	_ON_EX1_INP		; clear onex1 in progress flag
	clr	_ON_EX1_PND		; clear onex1 pending flag
	clr	EX1			; clear IE reg ex1 enable bit
    IF CPRINT
    	jb _CPRT_FLAG, $		; let print buffer empty
    ENDIF
 	ret

_INIT_PRINT:

	MOV	DPTR, #_OUTOTP		; TAIL OR OUTPUT POINTER
	MOV	A, #HIGH _OUTBUF	; GET MSB
	MOVX	@DPTR, A		; SAVE MSB
	INC	DPTR
	MOV	A, #LOW _OUTBUF
	MOVX	@DPTR, A		; SAVE LSB

	MOV	DPTR, #_OUTINP		; HEAD OR INPUT POINTER
	MOV	A, #HIGH _OUTBUF	; GET MSB
	MOVX	@DPTR, A		; SAVE MSB
	INC	DPTR
	MOV	A, #LOW _OUTBUF
	MOVX	@DPTR, A		; SAVE LSB

	MOV	_NULLCNT, #0		; SET NULL COUNTER to ZERO
	mov	_PHEAD, #1		; set print head to column 1
	clr	_CPRT_FLAG		; clear print in progress flag
	clr	_CPRT_INP		; print active flag
	RET


_PRTCOM:
	CLR	ES			; CLEAR ENABLE FOR SERIAL INTERRUPTS

	PUSH	DPL
	PUSH	DPH
		 
	MOV    	R0,A			; save the data byte
	MOV    	DPTR,#_OUTINP		; GET head POINTER address
	MOVX	A,@DPTR			; GET head ptr MSB
	MOV	R1,A			; save it 
	INC	DPTR			; bump the address
	MOVX	A,@DPTR			; GET head ptr LSB 

	MOV	DPL,A			; put head ptr in DPTR
	MOV	DPH,R1			;
	MOV	A,R0			; GET the DATA byte
	MOVX	@DPTR,A			; save it in the buffer at head ptr
	INC	DPTR			; incr head ptr to next location
	MOV	A,DPL			; SEE IF we're AT END OF BUFFER
	CJNE	A, # LOW _OUTBFE, _PRTCM1	; if not at end, jump

    IF _ALIGN EQ 0
	MOV	A,DPH 			; test the high byte
	CJNE	A, # HIGH _OUTBFE, _PRTCM1   	; if not at end, jump
    ENDIF
					; we are at end of buffer...
	MOV	DPTR,#_OUTBUF		; ...so make head = _OUTBUF [0]

_PRTCM1:
    IF _ALIGN EQ 0
	MOV	R0,DPL			; SAVE new head POINTER
	MOV	R1,DPH			; in R1:R0
	MOV	A,DPH
	MOV	DPTR,#_OUTINP		; get head ptr storage addr
	MOVX	@DPTR,A			; SAVE MSB of new head ptr 
	INC	DPTR			; bump the address
	MOV	A,R0			; 
	MOVX	@DPTR,A			; SAVE LSB of new head ptr
    
    ELSE
	MOV	R0,DPL			; SAVE new head POINTER bab 2/25/91
					; for prtcm2 compare
	MOV	A,DPL			; SAVE new head POINTER
	MOV	DPTR,#_OUTINP+1		; get head ptr storage addr
	MOVX	@DPTR,A			; SAVE LSB of new head ptr
    ENDIF


	mov	DPL, R0			; this mess added back in from
	mov	DPH, R1			; 2/10 version
    	inc	DPTR			; bab 2/25/91
	MOV	A,DPL			; SEE IF we're AT END OF BUFFER
	CJNE	A, # LOW _OUTBFE, _PRTCMF	; if not at end, jump

    IF _ALIGN EQ 0
	MOV	A,DPH 			; test the high byte
	CJNE	A, # HIGH _OUTBFE, _PRTCMF   	; if not at end, jump
    ENDIF
					; we are at end of buffer...
	MOV	DPTR,#_OUTBUF		; ...so make head = _OUTBUF [0]

_PRTCMF:
  
	mov	R0, DPL			; low byte of (inp ptr +1) in R0


	MOV	DPTR,#_OUTOTP		; GET OUTPUT POINTER
	INC	DPTR			; point to low byte

					; only test low byte of address since
					; a change must happen there as long
_PRTCM2:				; as buffer length is less than 256.
	MOVX	A,@DPTR			; get low byte of output ptr
	CJNE	A,_R0,_PRTCM3		; if inp ptr = out ptr, wait here
	SETB	ES			; INTERRUPT WINDOW
	NOP				
	NOP
	CLR	ES
	SJMP	_PRTCM2			; CONTINUE WAITING	 

_PRTCM3:
	jb	_CPRT_FLAG, _PRTCM4	; buffer to sbuf xfers already started
					; This is only place we set cprt_flag.
	setb	_CPRT_FLAG		; set the print in progress flag
	SETB	TI			; SET TRANS INT to start 1st xfer...
					; ...from buffer to serial port
					; cprt_flag is cleared in int23
					; if inp=out of outbuf pointers

_PRTCM4:
	POP	DPH
	POP	DPL
		
	SETB	ES			; ENABLE SERIAL INTERRUPTS

	RET
_INT23:
	jb	RI, _READ_INT		; jump if a receive interrupt

    IF UIO
	jnb	_UIO_OUT_FLAG, _INT23_UX	; leave if not user output
	lcall	_UIO_TI				; call user TI routine
	ljmp	_IN23ET0			; leave the int23 handler
_INT23_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _INT23_UPX		; leave if not user output
	lcall	_PAT_TI				; call user print@ TI routine
	ljmp	_IN23ET0			; leave the int23 handler
_INT23_UPX:
    ENDIF



_PRINT_INT:
	clr	TI			; clear transmit INTERRUPT
	jnb	_CNTRLS_FLAG, _PRINT_I0	; INHIBIT OUTPUT IF SET
	ljmp	_IN23ET0

_PRINT_I0:
	push	ACC			; SAVE ACC
	push	DPL			; PUSH ALL USED REG'S PSW PUSHED BEFORE 
	push	DPH

	push	_R0
	push	_R1
	push	_R2
	push	_R3

    IF _ALIGN EQ 0
	mov     DPTR, #_OUTINP		; get the head pointer address
	movx	A, @DPTR		; get the head pointer MSB
	mov	R0, A		  	; and save it
    	inc	DPTR			; bump the address
	movx	A, @DPTR		; get the head pointer LSB

    ELSE

	mov     DPTR, #_OUTINP+1	; get the head pointer address
	movx	A, @DPTR		; get the head pointer LSB

    ENDIF
    
	mov	R2, A			; and save it

	mov     DPTR, #_OUTOTP		; get the tail pointer address
	movx	A, @DPTR		; get the tail pointer MSBB
	mov	R1, A			; and save it
	inc	DPTR			; bump the address
	movx	A, @DPTR	     	; get the tail pointer LSB
	mov	R3, A			; and save it

	cjne	A, _R2, _PRINT_I1    	; if low bytes not the same, jump
	
    IF _ALIGN EQ 0
	mov	A, R1			; get the tail's high byte
	cjne	A, _R0, _PRINT_I1	; if high bytes not the same, jump
    ENDIF

	clr	_CPRT_FLAG		; head == tail clr print in progress

	ljmp	_OVREXT			; and exit


_PRINT_I1:
	mov	DPL, _R3	   	; head != tail
	mov	DPH, _R1	 	; get the tail pointer into DPTR
	movx	A, @DPTR	     	; get the data from the tail
	mov	SBUF, A			; SBUF it

	inc	DPTR			; advance the tail pointer
	mov	A, DPL			; tail pointer == address of _OUTBFE?
	cjne	A, #LOW _OUTBFE, _PRINT_I2	; if not equal continue

    IF _ALIGN EQ 0
	mov	A, DPH             	; get the high byte
	cjne	A, #HIGH _OUTBFE, _PRINT_I2	; if not equal continue
    ENDIF

	mov	DPTR, #_OUTBUF		; make tail point to _OUTBUF[0]

_PRINT_I2:
    IF _ALIGN EQ 0
	mov	R0, DPL			; Save the tail pointer
	mov	A, DPH			; first the high byte
	mov	DPTR, #_OUTOTP		; get the tails location
	movx	@DPTR, A		; save the MSB
	inc	DPTR			; bump the address
	mov	A, R0			; get the low byte
	movx	@DPTR, A		; save it

    ELSE
	mov	A, DPL			; only save the low byte
	mov	DPTR, #_OUTOTP+1	; get the tail's location
	movx	@DPTR, A		; save the MSB
    ENDIF

	ljmp	_OVREXT			; and exit


_READ_INT:

    ;-------------------------------------------------------------------------
    ; If user input we better call the user handler, since we can't have
    ; both a user and console input routine at the same time.
    ;
	
    IF UIO
	jnb	_UIO_INP_FLAG, _READ_INT_UX	; leave if not user input
	lcall	_UIO_RI				; call user RI routine
	ljmp	_IN23ET0			; leave the int23 handler
_READ_INT_UX:
    ENDIF

	PUSH	ACC
	MOV	A, SBUF			; receive data to acc
        CLR	RI

	jb	_IDLE_END, _INCK00	; not idle so proceed 
	ljmp	_IN23ET			; leave if idle (note we cleared RI)

_INCK00:
	CJNE	A,#_CNTRLC,_INCK01	; SEE IF CONTROL C 
	JB	_CNTRLC_FLAG,_INCK01	; CONTROL C DISABLED
	LJMP   _CNTLC			; leave and don't come back

_INCK01:
	CJNE	A, #_CNTRLS,_INCK02	; SEE IF CONTROL S
	SETB	_CNTRLS_FLAG		; SET BIT FOR OTHERS
	SJMP	_IN23ET			; EXIT

_INCK02:
	CJNE	A,#_CNTRLQ, _INCK03	; IS IT A CONTROL Q
	JNB	_CNTRLS_FLAG, _IN23ET	; BIT ALREADY CLEAR CONT
	SETB	TI			; START INTERRUPT
	CLR	_CNTRLS_FLAG		; CLEAR BIT FOR OTHERS
	SJMP	_IN23ET			; EXIT

_INCK03:
	PUSH	DPL			; PUSH USED REG'S - PSW PUSHED already
	PUSH	DPH
	PUSH	_R0
	PUSH	_R1
	PUSH	_R2
	PUSH	_R3

	MOV	R2, A			; SAVE DATA
         
	;SEE IF BUFFER IS FULL

	MOV	DPTR, #_TALPTR+1     ; GET TAIL OR OUTPUT POINTER
	MOVX	A, @DPTR             ; AND SAVE
	MOV	R0, A                ; LSB of tail pointer in R0

	MOV	DPTR, #_FIFOBE       ; GET END OF BUFFER
	MOV	R3, DPL              ; AND SAVE LSB of FIFOBE address in R3

	MOV	DPTR, #_HEDPTR       ; GET HEAD OR INPUT POINTER
	MOVX	A, @DPTR 
	MOV	R1, A                ; AND SAVE MSB of head in R1
	INC	DPTR 
	MOVX	A, @DPTR             ; GET LSB of head in A

	MOV	DPL, A               ; RESTORE LSB of head pointer
	MOV	DPH, R1              ; RESTORE MSB of head
	INC	DPTR			; incr head pointer
	MOV	A, DPL               ; SEE IF AT END OF BUFFER
	CJNE	A, _R3,_INCK04       ; NOT AT END CONTINUE
	MOV	DPTR, #_FIFOBF       ; GET START OF BUFFER as new head ptr

_INCK04:


         
	MOV     A,R2                ; GET DATA from R2
	MOVX    @DPTR,A             ; AND STORE at new head pointer
        
	MOV     A,DPH               ; SAVE new head POINTER
	MOV     R1,DPL
	MOV     DPTR,#_HEDPTR       ; AT LOCATION
	MOVX    @DPTR,A             ; SAVE MSB
	MOV     A,R1
	INC     DPTR
	MOVX    @DPTR,A		; SAVE LSB of new head ptr


	CJNE	A,_R0,_OVREXT   ; if not same, proceed
				; if here old tail == new head
	mov	DPTR, #_TALPTR	; get tail ptr addr
	movx	A, @DPTR	; get old tail MSB
	mov	DPH, A		; 
	mov	DPL, R0		; old tail now in DPTR
	inc	DPTR		; new tail, may be at buffer end?
	mov	A, DPL		; lsb of new tail to ACC
	CJNE	A, _R3, _TAILSAVE	; tail <> end so save it
	MOV	DPTR, #_FIFOBF		; GET START OF BUFFER as new tail ptr

_TAILSAVE:
	MOV     A,DPH               ; MSB of new tail
	MOV     R1,DPL
	MOV     DPTR,#_TALPTR       ; tail pointer storage location
	MOVX    @DPTR,A             ; SAVE MSB
	MOV     A,R1
	INC     DPTR
	MOVX    @DPTR,A		; SAVE LSB of new tail ptr

_OVREXT:
	POP    _R3			; RESTORE ALL USED REG"S
	POP    _R2  
	POP	_R1
	POP	_R0
	POP	DPH
	POP	DPL

_IN23ET:
	POP	ACC		        

_IN23ET0:
	POP	PSW			;PUSHED at vector 
	RETI				;EXIT INTERRUPT HANDLER

_PRINT_DONE:
    IF (CPRINT * PRINT_COMPLETE)
    	jb _CPRT_FLAG, $		; wait til buffer empty
    ENDIF
	RET

_PUTC:
	lcall	_PRINT_HEAD		; position the print head counter

    IF SPRINT
	jnb _SPRT_FLAG, _PUTC_SX	; go elsewhere if not serial print
    	lcall   _PRTLB_COM      	; output the character to the serial printer
	ret		       		; exit
_PUTC_SX:
    ENDIF

    IF UIO
	jnb _UIO_OUT_FLAG, _PUTC_UX 	; go elsewhere if not user output
    	lcall   _UIO_OUT	      	; else call the user output driver
	ret		       		; exit
_PUTC_UX:
    ENDIF

    IF UPRINT
	jnb _UPRT_FLAG, _PUTC_UPX 	; go elsewhere if not user output
    	lcall   _PRINT_AT	      	; else call the print@ output driver
	ret		       		; exit
_PUTC_UPX:
    ENDIF



_CPUTC:					; console print
  IF CPRINT
    lcall   _PRTCOM         		; output to the output buffer
  ENDIF
	ret				; done

_PRINT_HEAD:
	mov	R1, #_PHEAD

    IF SPRINT
	jnb 	_SPRT_FLAG, _PHD_SX
	mov	R1, #_SPHEAD
_PHD_SX:
    ENDIF

    IF UIO
	jnb _UIO_OUT_FLAG, _PHD_UX 	; go elsewhere if not user output
	mov	R1, #_UPHEAD
_PHD_UX:
    ENDIF

    IF UPRINT
	jnb _UPRT_FLAG, _PHD_UPX 	; go elsewhere if not user output
	mov	R1, #_UPHEAD
	ret		       		; exit
_PHD_UPX:
    ENDIF


	cjne	A, #20H, _PHD2		; is it a printable character?

_PHD2:
	jc	_PHD3	  	    	; continue test if not printable
	inc	@R1		    	; printable so bump print head counter
	ret
	
_PHD3:
	cjne	A, #CR, _PHD4		; jump if not CR
	mov	@R1, #1			; is CR, so reset print head counter
	ret

_PHD4:
	cjne	A, #BS, _PHD5		; dec print head counter if a backspace
	dec	@R1			; is BS, so decrement the print head counter
	ret
	
_PHD5:
	cjne	A, #LF, _PHD6		; if not a LF return
	pop	ACC			; else is LF so waste the calling stack
	pop	ACC
	ljmp	_PUT_NEW_LINE_2		; then output newline and take care of NULLs

_PHD6:
	ret				; not printable not CR, BS, LF so return

_PUT_NEW_LINE:
	mov	A, #CR			; carriage return
	lcall	_PUTC			; output it

_PUT_NEW_LINE_2:
	mov	A, #LF			; line feed

  IF SPRINT
	jnb	_SPRT_FLAG, _PNL_SX	; serial printer option if flag set
	lcall	_PRTLB_COM		; output it to the serial port
	sjmp	_PNL_4
_PNL_SX:
  ENDIF


    IF UIO
	jnb	_UIO_OUT_FLAG, _PNL_UX	; leave if not user output
	lcall	_UIO_OUT		; call user out routine
	sjmp	_PNL_4
_PNL_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _PNL_UPX	; leave if not user output
	lcall	_PRINT_AT		; call print@ out routine
	sjmp	_PNL_4
_PNL_UPX:
    ENDIF


  IF CPRINT
	lcall	_PRTCOM			; output it to the console
  ENDIF

_PNL_4:
	mov	A, _NULLCNT		; get the NULL count
	jz	$+7		    	; no NULLs if zero so exit
	mov	R0, A			; save the count
	clr	A		    	; this is the NULL
	lcall	_REP_CHAR		; output NULLs
	ret			    	; done
	
_REP_CHAR:

  IF SPRINT
	jnb	 _SPRT_FLAG, _RC_SX	; leave if not printer output
_RC_S1:
	lcall	_PRTLB_COM		; call printer out routine
	djnz	R0, _RC_S1		; decrement count and loop 'til done
	ret
_RC_SX:
  ENDIF

    IF UIO
	jnb	_UIO_OUT_FLAG, _RC_UX	; leave if not user output
_RC_U1:
	lcall	_UIO_OUT		; call user out routine
	djnz	R0, _RC_U1		; decrement count and loop 'til done
	ret
_RC_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _RC_UPX	; leave if not user output
_RC_UP1:
	lcall	_PRINT_AT		; call user print@ out routine
	djnz	R0, _RC_UP1		; decrement count and loop 'til done
	ret
_RC_UPX:
    ENDIF


_RC_2:
  IF CPRINT
  	push	_R0
	push	ACC
	lcall	_PRTCOM			; output the character to the console
	pop	ACC
	pop	_R0
	djnz	R0, _RC_2		; decrement count and loop 'til done
  ENDIF
	ret

_CNTLC_WOB:
	CLR	EA			; Disable all interrupts incl ES & RTC

_CNTLC:

_CNTLC1:
	MOV	DPTR,#_CNTLC2
	PUSH	DPL
	PUSH	DPH
	RETI				; close serial interrupt, pop PC to the DPTR value  

_CNTLC2:
	clr	C
	orl	C, _ON_EX1_INP
	orl	C, _ON_EX1_PND
	jnc	_CNTLC3			; was onex1 pend or in progress?
	mov	DPTR, #_CNTLC3		; if here, onex1 was in progress
	push	DPL
	push	DPH
	reti				; close onex1 interrupt, pop PC to the DPTR value  

_CNTLC3:
    IF CPRINT				; only check if console print is present
    	jnb	_CPRT_FLAG, _NOCHAR  	;jump if print not in progress
    	jnb	TI, $			; else wait 'til TI asserts from last char
    ENDIF

_NOCHAR:

	mov	SP, _SPCLEAR		; restore stack pointer 
    IF RUN_TRAP_LOC			; run trap in BCI51 code

      IF (DS5000 + TARGET_8XC51F)
    	setb	F0			;
	mov	A, #0AAH		;
	mov	B, #055H		; To detect a run trap at startup
      ENDIF
	ljmp 	_runtrap

    ENDIF

 ;********************************
    IF DS5000
    	jnb	_WDOG_FLAG, _CNTLC_DSX	; if wdog not active jump
	clr	EA   	  		; disable all interrupts
	sjmp	$			; wait for watchdog to expire
_CNTLC_DSX:
    ENDIF
 ;********************************
   
					; no runtrap or wdog active so...
	ret				; RETurn to whatever CALLed this program
					; otherwise crash ungracefully if nothing called it

_PRINT_REST:	

    IF (CPRINT * PRINT_COMPLETE)
    	jb _CPRT_FLAG, $			; wait til buffer empty
    ENDIF
	clr	_CPRT_INP			; clear cprt in progress flag

	lcall	_INT_PEND			; check for pending interrupts

	ret

_INT_PEND:

    IF ONEX1
	jnb	_ON_EX1_PND, _ONEX1_PND_X	; no onex1 pend so jump past
	mov	DPTR, #_ONEX1_PND_X 	
	PUSH	DPL				; push reti return addr... 
	PUSH	DPH				; ...for reti from onex1
	push	PSW				; int13 expects a pushed psw
	ljmp	_INT13_DISPATCH			; handle pending onex1
_ONEX1_PND_X:					; will return here if handled
    ENDIF

    IF ONTIME
	jnb	_ON_TIME_PND, _ONTIME_PND_X	; no ontime pend so jump past
	setb	_ON_TIME_INP			; ontime now in progress 
	clr	_ON_TIME_PND			; ontime no longer pending
	clr	_ON_TIME			; ontime no longer active
	mov	DPTR, #_ONTIME_PND_X 	
	PUSH	DPL				; push return addr... 
	PUSH	DPH				; ...for ret from ontime
	push	PSW				; int0B expects a pushed psw
	ljmp	_INT0B_PND_DISP			; handle pending ontime
_ONTIME_PND_X:					; will return here if handled
    ENDIF

	ret

_PRINT_ROM:


_PRR_1:
	clr	A
	movc	A, @A+DPTR		; get the byte to be printed (1)
	jz	_PRINT_ROM2	   	; if null terminator is present we're done (2)
	lcall	_PUTC			; put the character	(3)
	inc	DPTR			; point to the next character (1)
	sjmp	_PRR_1			; do another (2)


_PRINT_ROM2:
    IF (CPRINT * PRINT_COMPLETE)
	jb _CPRT_FLAG, $		; wait til buffer empty
    ENDIF
	ret	     			; done

_INP_WP:
	lcall	_PUT_PROMPT			; output prompt ('?' by default)...

_INP_NP:						; ...or call here for no prompt
	lcall	_INPUT				; fill the input buffer

    IF INPUT_ECHO
	lcall	_PUT_NEW_LINE		; new line after echoing input
    ENDIF

	mov     DPTR,#_INPBUF       ; get input buffer address...
	mov     R0,DPL              ; ...and save it in opreg0...
	mov     R2,DPH              ; ...for use by str_tok
	ret

 
_INPUT:
         MOV      DPTR,#_INPBFE       ;GET END OF BUFFER
         MOV      R2,DPL              ; AND SAVE
         MOV      DPTR,#_INPBUF       ;GET BUFFER POINTER
         MOV      R4,DPL              ; AND SAVE   **07/08/90
_INP_1:
         PUSH     DPL                 ;SAVE DATA POINTER
         PUSH     DPH                 ;
_INP_4:                              ;
         LCALL	_GET			;SEE IF DATA
         MOV	A,R0                 
         JZ	_INP_4			; NO KEEP LOOKING

         POP	DPH			;RETRIEVE DATA POINTER
         POP	DPL                 

         CJNE     A,#0DH,_INP_2		; jump if not a CR


    IF INPUT_ECHO			; echo CR?
	 push	ACC			; save char 2/16/91
         LCALL    _PUTC			; echo char to console
	 pop	ACC			; get char back 2/16/91
    ENDIF

         MOVX	@DPTR,A			; store CR in input buffer
         CLR	A                   
	 INC	DPTR			; point to null term place
         MOVX	@DPTR,A			; store null terminator
         RET                        	; finished
_INP_2:
         MOV      A,DPL               ;AT END OF BUFFER
         CJNE     A,_R2,_INP_3       ; NO CONTINUE
         SJMP     _INP_1             ;  YES GO LOOK FOR CR
_INP_3:
         MOV      A,R0                ;SAVE DATA

		 
         CJNE     A,#BSKEY,_INP_5   ;SEE IF BACKSPACE KEY  **07/08/90
         
  
         clr      c                  ;dec the dptr          **07/08/90
         mov      a,dpl
         cjne     a,_R4,_INP_3A
         sjmp     _INP_1            ;at first of buffer    **07/08/90

_INP_3A:                            ;                      **07/08/90
         clr      c                 ;                      **07/08/90
         subb     a,#1
         mov      dpl,a
         mov      a,dph
         subb     a,#0
         mov      dph,a

         MOV      A,#BS              ;GET A BACKSPACE       **07/08/90
    IF INPUT_ECHO
         LCALL    _PUTC              ; OUTPUT IT            **07/08/90
    ENDIF
_INP_4A:                             ;                      **07/08/90

    IF INPUT_ECHO
         MOV      A,#' '             ; CLEAR OLD CHARACTER  **07/08/90
         LCALL    _PUTC   
         MOV      A,#BS              ;GET A BACKSPACE       **07/08/90
         LCALL    _PUTC              ; OUTPUT IT            **07/08/90
    ENDIF
         SJMP     _INP_1

_INP_5:
         CJNE     A,#CNT_D,_INP_6   ;SEE IF CNT D          **07/08/90
         SJMP     _INP_4A            ; CLEAR CHARACTOR ON ONLY  **07/08/90

_INP_6:                              ;                      **07/08/90		 
		 MOVX     @DPTR,A
         INC      DPTR
    IF INPUT_ECHO
         LCALL    _PUTC             ; echo char to console
    ENDIF
         SJMP     _INP_1             ; INC POINTER AND CONTINUE

_PUT_PROMPT:
	lcall	_PUT_NEW_LINE  	; move to a fresh line
	mov 	A, #'?'			; the '?' character in acc
	lcall	_PUTC			; output it
	ret
_GET:

    IF UIO
	jnb _UIO_INP_FLAG, _GET_UX 	; go elsewhere if not user input
    	lcall   _UIO_INP	      	; else call the user input
	mov	R0, A			; put the gotten char in acc
	ret		       		; exit
_GET_UX:
    ENDIF

         ;SEE IF ANY DATA RECEIVED
	 ;IF HEAD POINTER == TAIL POINTER: NO DATA RECEIVED

	push	IE			; save interrupt status
	anl	IE, #0EBH		; mask out ES and EX1


	MOV     DPTR,#_HEDPTR+1		; GET HEAD OR INPUT POINTER
	MOVX    A,@DPTR			; AND SAVE
	MOV     R0,A			; LSB

         MOV     DPTR,#_FIFOBE		;GET END OF BUFFER
         MOV     R3,DPL			; AND SAVE
         
         MOV     DPTR,#_TALPTR        ;GET TAIL OR OUTPUT POINTER
         MOVX    A,@DPTR 
         MOV     R1,A                 ; AND SAVE MSB
         INC     DPTR 
         MOVX    A,@DPTR              ;  GET LSB
         CJNE    A,_R0,_GET01         ;INPUT POINTER <> OUTPUT POINTER
         MOV     R0,#00               ;+++FEB 14
         SJMP    _GETEXT              ;EXIT with 0 in R0
_GET01:
         MOV     DPH,R1               ;SET DPTR  14 FEB+++
         MOV     DPL,A

         INC     DPTR                 ;INC POINTER AND STORE

         MOV     A,DPL                ;GET POINTER
         CJNE    A,_R3,_GET02         ;NOT AT END CONTINUE
         MOV     DPTR,#_FIFOBF        ; GET START OF BUFFER
_GET02:

         MOVX    A,@DPTR              ;GET DATA AND SAVE
         MOV     R0,A				  ;PUT DATA CHAR IN R0
         MOV     R3,DPL               ;STORE OUTPUT POINTER
         MOV     A,DPH                ;  OR HEAD POINTER
         MOV     DPTR,#_TALPTR         
         MOVX    @DPTR,A
         MOV     A,R3
         INC     DPTR
         MOVX    @DPTR,A

_GETEXT:
	POP	IE			; restore interrupts if enabled
	RET		 		;END OF GET
_INIT_GET:

	MOV     DPTR,#_FIFOBF        ;GET START OF BUFFER
	MOV     R2,DPH               ; SAVE DPTR
	MOV     R1,DPL    
  
	MOV     DPTR,#_TALPTR        ;TAIL OR OUTPUT POINTER
	MOV     A,R2                 ; GET MSG
	MOVX    @DPTR,A              ;  SAVE MSB
	INC     DPTR
	MOV     A,R1
	MOVX    @DPTR,A              ;   SAVE LSB

	MOV     DPTR,#_HEDPTR        ;HEAD OR INPUT POINTER
	MOV     A,R2                 ; GET MSG
	MOVX    @DPTR,A              ;  SAVE MSB
	INC     DPTR
	MOV     A,R1
	MOVX    @DPTR,A              ;   SAVE LSB
	RET

_STR_TOK:
	mov	R1, #2Ch	; setup for compares; this is the comma
	mov	R3, #21h	; this is COMMA XOR CR (2Ch XOR 0Dh)
	mov	A, R0		; get the low byte of OPREG0
	orl	A, R2		; see if OPREG0 contains a NULL pointer
	jz	_STR_TOK_3	; jump if NULL and continue with prev string
	lcall	_STR_TOK_5	; save current str tok addr
	
_STR_TOK_1:
	movx	A, @DPTR	; get the first byte of the string
	jz	_STR_TOK_4	; if NULL character we're done
	xrl	A, R1		; test for comma
	jz	_STR_TOK_2	; zero if character is a comma
	xrl	A, R3		; test for carriage return
	jz	_STR_TOK_2	; zero if character is a CR
	inc	DPTR		; not comma, CR or NULL so continue with next char
	sjmp	_STR_TOK_1

_STR_TOK_2:			; here when we find a COMMA or a CR
	movx	@DPTR, A     	; NULL terminate the located string
	inc	DPTR		; point to next character
	mov	A, DPL
	mov	R1, DPH		; temp save of high byte of current string address
	mov	DPTR, #_STR_TOK_NXT	; get address of save address location
	movx	@DPTR, A	; save low byte
	inc	DPTR		; point to high byte address
	mov	A, R1		; get high byte
	movx	@DPTR, A	; save high byte
	mov	DPL, R0		; move address to DPTR for str_len
	mov	DPH, R2		;
	ret			; OPREG0 and DPTR contain address of token
	
_STR_TOK_3:			; here when _STR_TOK called with a NULL pointer
	mov	DPTR, #_STR_TOK_NXT	; get address of saved address location
	movx	A, @DPTR	; get low byte of address
	mov	R0, A		; save it
	inc	DPTR		; point to high byte
	movx	A, @DPTR	; get high byte
	mov	R2, A		; save it
	lcall	_STR_TOK_5	; save current str tok addr
	sjmp	_STR_TOK_1	; do the search

_STR_TOK_4:			; here when we encounter the NULL terminator
	mov	R0, A		; so return a NULL pointer
	mov	R2, A
	ret

_STR_TOK_5:					
	mov	DPTR, #_STR_TOK_CUR	; address to hold current token addr
	mov	A, R0
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2
	movx	@DPTR, A	; store token address for later use

	mov	DPL, R0		; point to string Note: this must be here for
	mov	DPH, R2		; rest of str_tok scan to work
	ret

_ATOI:
	mov	DPH, R2
	mov	DPL, R0		; copy opreg0 to DPTR bab 7/9/90
	
	clr	F0     	; initiallize
	mov	R4, #10		; presume decimal conversion
	mov	R0, DPL		; save the DPTR
	mov	R2, DPH
	sjmp	_ATOI_1+1

_ATOI_1:			; see if we will be doing a hex conversion
	inc	DPTR		; advance the pointer
	movx	A, @DPTR	; get character from string
	jz	_ATOI_3		; if NULL we're done
	anl	A, #0DFh	; convert to upper case if a letter else trash it
	xrl	A, #'H'		; is it a 'H'?
	jnz	_ATOI_1		; if not 'H' keep looking

_ATOI_2:
	movx	@DPTR, A	; replace hex designator with NULL
	mov	R4, #16		; remember that we will be doing hex conversion

_ATOI_3:
	mov	A, R0		; test to be sure that we aren't converting...
	xrl	A, DPL		; ... a NULL string
	jnz	_ATOI_3A
	mov	A, R2
	xrl	A, DPH
	jz	_ATOI_ERR	; if it is a NULL string, JUMP

_ATOI_3A:
	clr	A
	
	mov	DPL, R0		; restore the DPTR
	mov	DPH, R2
	mov	R0, A		; ACC == zero (left from 'H' search)
	mov	R2, A
	mov	B, R4		; get the divisor
	jb	B.4, _ATOI_5	; doing hex so skip the next stuff
	movx	A, @DPTR	; get the first byte
	cjne	A, #'-', $+7	; jumps if not a minus sign
	setb	F0   	; is a '-' so remember this
	sjmp	_ATOI_4
	cjne	A, #'+', _ATOI_5	; jumps if not a '+'

_ATOI_4:
	inc	DPTR		; point to the next byte

_ATOI_5:
	movx	A, @DPTR	; get the byte
	jz	_ATOI_END	; found the null terminator
	cjne	A, #'9'+1, $+3	; jumps if not equal to '9'
	jnc	_ATOI_6		; carry clr if greater than '9'
	cjne	A, #'0', $+3	; jumps if not equal to '0'
	jc	_ATOI_ERR	; carry set if less than '0'
	sjmp	_ATOI_7		; go do the conversion

_ATOI_6:
	jnb	B.4, _ATOI_ERR	; jump if we're doing a decimal conversion
	anl	A, #0DFh	; convert to upper case
	cjne	A, #'F'+1, $+3	; jumps if not equal to 'F'
	jnc	_ATOI_ERR	; carry clr if greater than 'F'
	cjne	A, #'A', $+3	; jumps if not equal to 'A'
	jc	_ATOI_ERR	; carry set if less than 'A'
	subb	A, #37h		; convert ASCII to a hex value
	
_ATOI_7:	
	mov	R3, A		; save the byte
	mov	A, R0		; multiply the low byte
	mul	AB
	mov	R1, B		; save the result high byte
	mov	R0, A		; save the low byte
	mov	B, R4
	mov	A, R2		; multiply OPREG0 high byte
	mul	AB
	jb	OV, _ATOI_ERR	; if OV then number is two big to convert
	add	A, R1		; add the high intermediate result
	mov	R2, A		; save it
	mov	A, R3		; get the input byte back		
	anl	A, #0FH		; mask off the upper nibble
	add	A, R0		; accumulate
	mov	R0, A		; save it
	clr	A
	addc	A, R2		; propogate the carry
	mov	R2, A		; save the result
	jc	_ATOI_ERR	; if carry we overflowed
	mov	B, R4		; get the divisor
	sjmp	_ATOI_4		; do it again
	
_ATOI_END:
	clr	C		; clear leftover from cjne bab
	jnb	F0, _ATOI_EXIT	; if the number is positive we're done; else ...
	mov	A, R2		; ... get MSB and see if bit 7 is set
	jnb	ACC.7, _ATOI_END_1	; if bit 7 of MSB clear we haven't overflowed so quit
	cpl	ACC.7		; test for special case -32768 clear acc msb
	orl	A, R0		; or in low byte
	jnz	_ATOI_ERR	; we overflowed

_ATOI_END_1:			; was negative so cleanup...
	clr	F0	; clr the flag
	mov	A, R2		; ... get MSB and see if bit 7 is set
	orl	A, R0		; now acc= R0 orl R2
	jz	_ATOI_EXIT	; exit with no C if val is zero
	lcall	_I_TWOS_COMP_0	; ...else, complement the number
	setb	C		; flag to compiler that number is negative
	ret			; done

_ATOI_ERR:			  		
	clr	C		; carry not reliable if error
	setb	F0  	; flag to the compiler that an error ocurred

_ATOI_EXIT:
	ret			; done





_CHECK_UI:
	jb	F0, _VAL_ERR
	jc	_VAL_NEG
	ret			; OK return 

_CHECK_SI:
	jb	F0, _VAL_ERR
	jc	_CHECK_SI_NEG
	mov	A, R2		; is positive, so bit R2.7 should...
	anl	A, #80H		; ...be zero, so mask all but R2.7...
	jnz	_VAL_BIG	; ...and jump if not zero
_CHECK_SI_NEG:			; here if pos and OK or neg
	clr	C		; clr possible neg flag
	ret			; OK return 

_CHECK_UC:
	jb	F0, _VAL_ERR
	jc	_VAL_NEG
	mov	A, R2		; too big if upper byte nonzero
	jnz	_VAL_BIG
	ret			; OK return 

_CHECK_SC:
	jb	F0, _VAL_ERR	; has conversion error
	jc	_CHECK_SC_NEG	; is negative
	mov	A, R0		; R0.7 should be zero..
	anl	A, #80H		; ...mask all but R0.7
	orl	A, R2		; too big if R0.7 or ... 
	jnz	_VAL_BIG	; ...upper byte nonzero
	ret			; OK return 

_CHECK_SC_NEG:	
	mov	A, R0		; is neg, so lower byte bit 7 (sign)...
	jnb	ACC.7, _VAL_BIG	; ... only zero if too neg
	ret			; OK return 

_VAL_ERR:
    IF ERR_MSG	
	mov	DPTR, #_str_val_err
    ENDIF
	sjmp	_CHECK2

_VAL_NEG:
    IF ERR_MSG	
	mov	DPTR, #_str_val_neg
    ENDIF
	sjmp	_CHECK2

_VAL_BIG:
    IF ERR_MSG	
	mov	DPTR, #_str_val_big
    ENDIF
	sjmp	_CHECK2

_CHECK2:
	setb	F0  		; set error flag for any/all errors

    IF ERR_MSG		; conditional error message display
	mov	R0, DPL
	mov	R2, DPH
	lcall	_PRINT_ROM
    ENDIF
 	lcall	_PUT_NEW_LINE	; always output a newline?

	ret

_I_TWOS_COMP_0:
	clr		A			; setup
	clr		C
	subb	A, R0		; convert LSByte
	mov		R0, A		; save it
	clr		A			; setup
	subb	A, R2		; convert MSByte
	mov		R2, A		; save it
	clr		C
	ret					; done

_ILT:
	lcall	_SI_RELOP_TEST
	ljmp	_LT_COM

_SI_RELOP_TEST:
	clr		F0
	mov		A, R3				; get OPREG1 sign
	rlc		A
	mov		A, R2				; get OPREG0 sign
	lcall	_OP_SIGNS			; adjust for the jump table
	mov		DPTR, #_SRT_1		; get the address of the jump table
	jmp		@A+DPTR				; jump from jump table
	
_SRT_1:
	sjmp	_SRT_2				; both values are positive
	setb	C					; OPREG0 negative, OPREG1 positive
	ret
	ret							; OPREG0 positive, OPREG1 negative
	nop							; occupy space

_SRT_4:							; both values are negative
	mov		A, R2				; swap the OPREGs then compare as unsigned
	xch		A, R3				; R2 to R3
	mov		R2, A				; R3 to R2
	mov		A, R0				; swap low bytes
	xch		A, R1				; R0 to R1
	mov		R0, A				; R1 to R0
	lcall	_UI_RELOP_TEST		; do the compare
	jb		F0, $+4				; convert the result if OPREG0 != OPREG1
	cpl		C					;
	ret
	
_SRT_2:							; both values are positive
	lcall	_UI_RELOP_TEST		; do the compare
	ret
	
_OP_SIGNS:
	rlc	A					; one sign in ACC.0, the other in carrry
	rlc	A					; 0 - 3 (ACC.1 & ACC.0)
	rlc	A					; 0, 2, 4, 6 (ACC.2 and ACC.1)
	clr	C
	anl	A, #6				; clear all remaining bits
	ret							; done

_RO_COM:
_NEQ_COM:
	cpl		F0				; compliment F0 so we can share _EQ_COM

_EQ_COM:
	mov		C, F0
	sjmp	_RO_COM_1
	
_GT_COM:
	cpl		C
	
_LT_COM:
	anl		C, /F0
	sjmp	_RO_COM_1


_GE_COM:
	cpl		C

_LE_COM:
	orl		C, F0				

_RO_COM_1:
	jc		_RO_COM_2			; carry == 1 then OPREG0 < OPREG1
	ljmp	_RET_ZERO			; 

_RO_COM_2:
	ljmp	_RET_65K			; 

_UI_RELOP_TEST:
	clr	F0
	mov	A, R2
	cjne	A, _OPREG_1H, _URT_X	; compare the high bytes: jump if not equal

_UC_RELOP_TEST:				; entry point for character compares
	clr	F0
	mov	A, R0			; high bytes equal compare low bytes
	cjne	A, _OPREG_1L, _URT_X	; compare the low bytes: jump if not equal
	setb	F0			; F0 == 1 then:  OPREG0 == OPREG1
					; carry == 1 then:  OPREG0 < OPREG1
_URT_X:					; else: OPREG0 > OPREG1
	ret				; done 
	
_RET_ZERO:
	clr		A				; the ZERO
	mov		R0, A			; put the ZERO in OPREG0
	mov		R2, A
	ret						; returns to the routine that called the compare
	
_RET_65K:
	mov		R0, #0FFh		; put the 65535 in OPREG0
	mov		R2, #0FFh
	ret						; returns to the routine that called the compare
	
_IGE:
	lcall	_SI_RELOP_TEST
	ljmp	_GE_COM

_ONGO:
	MOV   A,R0
    ADD   A,R0			; mult R0 by two to get # of bytes offset

    MOV   DPL,R1		; base addr of table into dptr
    MOV   DPH,R3		;
    ADD   A,DPL			; add offset
    MOV   DPL,A
    MOV   A,#0
    ADDC  A,DPH
    MOV   DPH,A
    CLR   A
    MOVC  A,@A+DPTR     ;GET ADDRESS IN TABLE IN DPTR
    MOV   R2,A
    INC   DPTR
    CLR   A
    MOVC  A,@A+DPTR     ;GET LEAST SIG PART OF ADDRESS
    MOV   DPL,A
    MOV   A,R2
    MOV   DPH,A
    CLR   A       
    JMP   @A+DPTR		; jump to the location in the table and
						; begin executing there
_ONGO_ERRS:

_ONGO_ERR1:			; expr negative
	IF ERR_MSG
		mov		DPTR, #_ongo_expr_neg
	ENDIF
		sjmp	_ONGO_ERRCOM

_ONGO_ERR2:			; expr too big
	IF ERR_MSG
		mov		DPTR, #_ongo_expr_big
	ENDIF
		sjmp	_ONGO_ERRCOM

_ONGO_ERRCOM:
		mov A, #ONGO_EXPR				
	 	ljmp	_ERR_HAND
;_%%DS5_XBY_PE:

_DS_XBY_PE_GET:
	push 	IE
	anl	IE, #82H		
	orl 	MCON, #04H   		
	clr	A			
	mov	R2, A 
	mov	DPL, R1			
	mov	DPH, R3
	movx	A, @DPTR		
	mov	R0, A			
	anl 	MCON, #0FBH   		
	pop	IE			
	ret

_DS_XBY_PE_SET:
	push 	IE
	anl	IE, #82H		
	orl 	MCON, #04H   		
	mov	DPL, R1			
	mov	DPH, R3
	mov	A, R0			
	movx	@DPTR, A		
	anl 	MCON, #0FBH   		
	pop	IE			
	ret

_PH0:
	setb	F0			; leading zeros supression bit
	sjmp	_PH1A

_PH1:
	clr    	F0			; print even zero digits

_PH1A:
	mov	DPH, R3			; point to destination address
	mov	DPL, R1
	
_PHX_1:
	mov	A, R2			; get the high byte
	swap	A			; exchange the nibbles to print high nibble
	lcall	_PHX_2			;
	mov	A, R2			; get the high byte again
	lcall	_PHX_2			;
	clr	F0			; must print all other nibbles even if zero
	mov	A, R0			; get the low byte
	swap	A			; exchange the nibbles to print high nibble
	lcall	_PHX_2			;
	mov	A, R0			; get the low byte again
	lcall	_PHX_2			;
	mov	A, #'H'			; hexadecimal indicator
	movx	@DPTR, A		; save it
	inc	DPTR
	clr	A			; null terminator
	movx	@DPTR, A		; save it
	ret

_PHX_2:
	anl	A, #0FH			; mask the upper nibble
	jnb	F0, $+7			; in zero suppression mode?
	jz	_PHX_3			; yes exit if zero
	clr	F0			; clear the zero suppression flag
	add	A, #90H			; 90H to 9FH
	da	A			; 90H to 99H, 00H to 05H + carry
	addc	A, #40H			; 0D0H to 0D9H +carry, 41H to 46H
	da	A			; 30H to 39H, 41 to 46H == '0' to '9', 'A' to 'F'
	movx	@DPTR, A		; save it
	inc	DPTR			; point to next location
	
_PHX_3:
	ret

_PRINT:					; print from external memory

_PRINTC:			   	; console print routine begins here

_PRINT1:
	movx	A, @DPTR		; get the byte to be printed (1)
	jz	 _PRINT2		; if null terminator is present we're done (2)
	lcall	_PUTC			; put the character	(3)
	inc	 DPTR			; point to the next character (1)
	sjmp	_PRINT1			; do another (3)

_PRINT2:
    IF (CPRINT * PRINT_COMPLETE)
    	jb _CPRT_FLAG, $		; wait til buffer empty
    ENDIF
  ret					; done

_CHR_PUT:
	mov	A, R0		; get the byte in the accumulator
	movx	@DPTR, A	; put the byte
	ret			; done

_CHR_GET:
	movx	A, @DPTR	; get the byte
	mov	R0, A		; put it in OPREG0
	mov	R2, #0		; clr the high byte
	ret			; done

;_%%DS1283:


_DS83_HSEC_RD:
	mov	R1, #DS_83HSEC		
	mov	DPTR, #_DS83_HSEC 	
	lcall	_DS83_REG_RD2		
	ret

_DS83_REG_RD2:
	lcall	_DS1283_RB		
	mov	A, R0			
_DS83_REG_RD3:
	lcall	_BCD_TO_HEX		
_DS83_REG_RD4:
	movx	@DPTR, A		
	mov	R0, A		 	
	mov	R2, #0		 	
	ret

_DS83_SEC_RD:
	mov	R1, #DS_83SEC		
	mov	DPTR, #_DS83_SEC 	
	lcall	_DS83_REG_RD2		
	ret

_DS83_MIN_RD:
	mov	R1, #DS_83MIN		
	mov	DPTR, #_DS83_MIN 	
	lcall	_DS83_REG_RD2		
	ret

_DS83_DAY_RD:
	mov	R1, #DS_83DAY		
	mov	DPTR, #_DS83_DAY 	
	lcall	_DS83_REG_RD2		
	ret

_DS83_DAY_RDS:				

	mov	DPTR, #_DS_DAY_TAB	
	dec	A			
	mov	B, #3			
	mul	AB			

	ret

_DS83_DATE_RD:
	mov	R1, #DS_83DATE		
	mov	DPTR, #_DS83_DATE 	
	lcall	_DS83_REG_RD2		
	ret

_DS83_MONTH_RD:
	mov	R1, #DS_83MONTH		
	mov	DPTR, #_DS83_MONTH 	
	lcall	_DS1283_RB		
	mov	A, R0
	anl	A, #01FH		
	lcall	_DS83_REG_RD3		
	ret

_DS83_YEAR_RD:
	mov	R1, #DS_83YEAR		
	mov	DPTR, #_DS83_YEAR 	
	lcall	_DS83_REG_RD2		
	ret

_DS83_HOUR_RD:
	mov	R1, #DS_83HOUR		
	mov	DPTR, #_DS83_HOUR 	
	lcall	_DS1283_RB		
	mov	A, R0			
	jnb	ACC.6, _DS83_HR_RD24	
	anl	_R0, #01FH		
_DS83_HR_RD24:
	anl	_R0, #03FH		
	mov	A, R0			
	lcall	_DS83_REG_RD3		
	ret


_DS83_1224_RD:
	mov	R1, #DS_83HOUR		
	lcall	_DS1283_RB		
	mov	A, R0			
	mov	DPTR, #_DS83_1224 	
	jb	ACC.6, _DS83_1224_12	
	mov	A, #24
	sjmp	_DS83_1224_A
_DS83_1224_12:
	mov	A, #12
_DS83_1224_A:
	lcall	_DS83_REG_RD4		
	ret


_DS83_AMPM_RD:
	mov	R1, #DS_83HOUR		
	lcall	_DS1283_RB		
	mov	A, R0			
	mov	DPTR, #_DS83_AMPM 	
	jb	ACC.6, _DS83_AMPM_12	
	mov	A, #0
	sjmp	_DS83_AMPM_A
_DS83_AMPM_12:
	mov	C, ACC.5		
	mov	A, #0
	mov	ACC.0, C		
_DS83_AMPM_A:
	lcall	_DS83_REG_RD4		
	ret

_DS83_CMD_RD:
	mov	R1, #DS_83CMD		
	mov	DPTR, #_DS83_CMD 	
	lcall	_DS1283_RB		
	mov	A, R0			
	lcall	_DS83_REG_RD4		
	ret

_DS83_UPDATE_RD:
	lcall	_DS83_CMD_RD		
	mov	A, R0			
	mov	DPTR, #_DS83_UPDATE 	
	mov	C, ACC.7		
	mov	A, #00H			
	mov	ACC.0, C		
	lcall	_DS83_REG_RD4		
	ret	


_DS83_RUN_RD:
	setb	F0			
	sjmp	_DS83_RSQ_RD1
_DS83_SQW_RD:
	clr	F0			

_DS83_RSQ_RD1:
	mov	R1, #DS_83MONTH		
	lcall	_DS1283_RB		
	mov	A, R0			
	jnb	F0, _DS83_SQW_RD1	

_DS83_RUN_RD1:
	mov	C, ACC.7		
	cpl	C
	mov	A, #0			
	mov	ACC.0, C		
	mov	DPTR, #_DS83_RUN 	
	lcall	_DS83_REG_RD4		
	sjmp	_DS83_RSQ_RDX

_DS83_SQW_RD1:
	mov	A, R0			
	mov	C, ACC.6		
	cpl	C
	mov	A, #0			
	mov	ACC.0, C		
	mov	DPTR, #_DS83_SQW 	
	lcall	_DS83_REG_RD4		

_DS83_RSQ_RDX:
	ret




_DS83_INTV_HSEC_RD:
	mov	R1, #DS_83INTV_HSEC	
	mov	DPTR, #_DS83_INTV_HSEC 	
	lcall	_DS83_REG_RD2		
	ret

_DS83_INTV_SEC_RD:
	mov	R1, #DS_83INTV_SEC	
	mov	DPTR, #_DS83_INTV_SEC 	
	lcall	_DS83_REG_RD2		
	ret


_DS83_MIN_AL_RD:
	mov	R1, #DS_83MIN_AL	
	mov	DPTR, #_DS83_MIN_AL 	
	lcall	_DS1283_RB		
	anl	_R0, #07FH		
	mov	A, R0			
	lcall	_DS83_REG_RD3		
	ret


_DS83_HOUR_AL_RD:
	mov	R1, #DS_83HOUR_AL	
	mov	DPTR, #_DS83_HOUR_AL 	
	lcall	_DS1283_RB		
	anl	_R0, #07FH		
	mov	A, R0			
	lcall	_DS83_REG_RD3		
	ret

_DS83_DAY_AL_RD:
	mov	R1, #DS_83DAY_AL	
	mov	DPTR, #_DS83_DAY_AL 	
	lcall	_DS1283_RB		
	anl	_R0, #07FH		
	mov	A, R0			
	lcall	_DS83_REG_RD3		
	ret


_DS83_MASK_AL_RD:
	mov	B, #0			
	mov	R1, #DS_83MIN_AL	
	lcall	_DS1283_RB		
	mov	A, R0			
	mov	C, ACC.7
	mov	B.2, C

	mov	R1, #DS_83HOUR_AL	
	lcall	_DS1283_RB		
	mov	A, R0			
	mov	C, ACC.7
	mov	B.1, C

	mov	R1, #DS_83DAY_AL	
	lcall	_DS1283_RB		
	mov	A, R0			
	mov	C, ACC.7
	mov	B.0, C

	mov	DPTR, #_DS83_MASK_AL 	
	mov	A, B			
	lcall	_DS83_REG_RD4
	ret

_DS83_MASK_AL_WR:
	mov	DPTR, #_DS83_MASK_AL 	
	mov	A, R0			
	mov	B, A			
	movx	@DPTR, A		

	mov	C, ACC.2		
	mov	R1, #DS_83MIN_AL	
	lcall	_DS83_MASK_AL_WR2
	mov	C, ACC.1		
	mov	R1, #DS_83HOUR_AL	
	lcall	_DS83_MASK_AL_WR2
	mov	C, ACC.0		
	mov	R1, #DS_83DAY_AL	
	lcall	_DS83_MASK_AL_WR2
	ret				

_DS83_MASK_AL_WR2:
	push	ACC			
	lcall	_DS1283_RB		
	mov	A, R0			
	mov	ACC.7, C		
	mov	R0, A			
	lcall	_DS1283_WB		
	pop	ACC
	ret				


_DS83_HOUR_AL_WR:
	mov	R1, #DS_83HOUR_AL	
	mov	DPTR, #_DS83_HOUR_AL 	
	ljmp	_DS83_HOUR_WR2		

_DS83_DAY_AL_WR:
	mov	R1, #DS_83DAY_AL	
	mov	DPTR, #_DS83_DAY_AL 	
_DS83_DAY_AL_WR2:
	mov	A, R0			
	movx	@DPTR, A		
	lcall	_HEX_TO_BCD		
	push	ACC			
	lcall	_DS1283_RB		
	anl	_R0, #80H		
	pop	ACC			
	orl	A, R0			
	mov	R0, A			
	lcall	_DS1283_WB		
	ret

_DS83_MIN_AL_WR:
	mov	R1, #DS_83MIN_AL	
	mov	DPTR, #_DS83_MIN_AL 	
	sjmp	_DS83_DAY_AL_WR2	







_DS83_HSEC_WR:
	mov	R1, #DS_83HSEC		
	mov	DPTR, #_DS83_HSEC 	
	lcall	_DS83_REG_WR2		
	ret

_DS83_REG_WR2:
	mov	A, R0			
	movx	@DPTR, A		
	lcall	_HEX_TO_BCD		
	mov	R0, A			
	lcall	_DS1283_WB		
	ret

_DS83_REG_WRH:
	mov	A, R0			
	movx	@DPTR, A		
	lcall	_DS1283_WB		
	ret


_DS83_SEC_WR:
	mov	R1, #DS_83SEC		
	mov	DPTR, #_DS83_SEC 	
	lcall	_DS83_REG_WR2		
	ret

_DS83_MIN_WR:
	mov	R1, #DS_83MIN		
	mov	DPTR, #_DS83_MIN 	
	lcall	_DS83_REG_WR2		
	ret


_DS83_HOUR_WR:
	mov	R1, #DS_83HOUR		
	mov	DPTR, #_DS83_HOUR 	
_DS83_HOUR_WR2:
	mov	A, R0			
	movx	@DPTR, A		
	lcall	_HEX_TO_BCD		
	push	ACC			

	lcall	_DS1283_RB		
	mov	A, R0
	jnb	ACC.6, _DS83_HRWR_24	
	anl	A, #0E0H		
	pop	B			
	orl	A, B			
	sjmp	_DS83_HRWR_A		
_DS83_HRWR_24:
	mov	C, ACC.7		
	pop	ACC			
	mov	ACC.7, C		
_DS83_HRWR_A:
	mov	R0, A			
	lcall	_DS1283_WB		
	ret



_DS83_AMPM_WR:
	push	_R0			
	mov	R1, #DS_83HOUR		
	mov	DPTR, #_DS83_AMPM 	
	lcall	_DS1283_RB		
	mov	A, R0			
	jnb	ACC.6, _DS83_APWR_24	
	pop	B
	mov	C, B.0
	mov	ACC.5, C		
	movx	@DPTR, A		
	mov	R0, A			
	lcall	_DS1283_WB		
	ret

_DS83_APWR_24:
	pop	B			
	mov	A, #0			
	movx	@DPTR, A		
	ret


_DS83_DAY_WR:
	mov	R1, #DS_83DAY		
	mov	DPTR, #_DS83_DAY 	
	lcall	_DS83_REG_WR2		
	ret

_DS83_DATE_WR:
	mov	R1, #DS_83DATE		
	mov	DPTR, #_DS83_DATE 	
	lcall	_DS83_REG_WR2		
	ret

_DS83_YEAR_WR:
	mov	R1, #DS_83YEAR		
	mov	DPTR, #_DS83_YEAR 	
	lcall	_DS83_REG_WR2		
	ret


_DS83_MONTH_WR:
	mov	R1, #DS_83MONTH		
	mov	DPTR, #_DS83_MONTH 	
	mov	A, R0			
	movx	@DPTR, A		
	lcall	_HEX_TO_BCD		
	push	ACC			

	lcall	_DS1283_RB		
	anl	_R0, #0C0H		
	pop	ACC
	orl	_R0, A			
	lcall	_DS1283_WB
	ret


_DS83_1224_WR:
	push	_R0			
	lcall	_DS83_HOUR_RD		
	pop	ACC		   	
	cjne	A, #24, _DS83_1224_WR1	
_DS83_1224_WR1:
	mov	A, R0			
	mov	ACC.6, C		
	mov	R0, A			
	lcall	_DS1283_WB
	ret

_DS83_UPDATE_WR:
	mov	R1, #DS_83CMD		
	mov	A, R0			
	push	ACC			
	lcall	_DS1283_RB		
	pop	ACC			
	mov	C, ACC.0		
	mov	A, R0			
	mov	ACC.7, C		
	mov	DPTR, #_DS83_UPDATE 	
	movx	@DPTR, A		
	mov	R0, A			
	lcall	_DS1283_WB		
	ret

_DS83_RUN_WR:
	mov	R1, #DS_83MONTH		
	mov	DPTR, #_DS83_RUN 	
	mov	A, R0			
	movx	@DPTR, A		
	push	ACC			
	lcall	_DS1283_RB		
	pop	ACC			
	mov	C, ACC.0		
	cpl	C			
	mov	A, R0			
	mov	ACC.7, C		
	mov	R0, A			
	lcall	_DS1283_WB		
	ret

_DS83_SQW_WR:
	mov	R1, #DS_83MONTH		
	mov	DPTR, #_DS83_SQW 	
	push	_R0			
	mov	A, R0
	movx	@DPTR, A		
	lcall	_DS1283_RB		
	pop	ACC			
	mov	C, ACC.0		
	cpl	C			
	mov	A, R0			
	mov	ACC.6, C		
	mov	R0, A			
	lcall	_DS1283_WB		
	ret

_DS83_CMD_WR:
	mov	R1, #DS_83CMD		
	mov	DPTR, #_DS83_CMD 	
	lcall	_DS83_REG_WRH		
	ret



_DS83_INTV_HSEC_WR:
	mov	R1, #DS_83INTV_HSEC	
	mov	DPTR, #_DS83_INTV_HSEC 	
	lcall	_DS83_REG_WR2		
	ret

_DS83_INTV_SEC_WR:
	mov	R1, #DS_83INTV_SEC	
	mov	DPTR, #_DS83_INTV_SEC 	
	lcall	_DS83_REG_WR2		
	ret





_BCD_TO_HEX:
	push	B
	mov 	R0, A			
	anl	A, #0F0H 		
	swap	A			
	mov 	B, #10			
	mul	AB			
	mov	B,A			
	xch	A, R0			
	anl	A, #00FH 		
	add	A, B			
	pop	B
	ret




_HEX_TO_BCD:
	push	B
	mov	B, #10
	div	AB		
	swap	A
	add	A,B
	pop	B
	ret



_DS1283_RB:
	push	DPL			
	push	DPH
	push 	IE
	anl	IE, #82H		
	orl 	MCON, #04H   		
	mov	DPH, #0
	mov	DPL, R1			
	movx	A, @DPTR		
	mov	R0, A			
	anl 	MCON, #0FBH   		
	pop	IE			
	pop	DPH
	pop	DPL
	ret



_DS1283_WB:
	push 	IE
	anl	IE, #82H		
	orl 	MCON, #04H   		
	mov	DPH, #0
	mov	DPL, R1			
	mov	A, R0			
	movx	@DPTR, A		
	anl 	MCON, #0FBH   		
	pop	IE			
	ret

_IEQ:
	lcall	_SI_RELOP_TEST
	ljmp	_EQ_COM

_UCTOA:
	mov	DPL, R1		; point to the destination
	mov	DPH, R3
	mov	R2,	 #0		; insure 0 for msb for BTOA
	lcall	_BTOA	; do the conversion.
	ret

_BTOA:
	clr	C
	mov	A, R0		; is the value zero?
	orl	A, R2
	jnz	_BTOA_1		; jump if it isn't
	
	push	ACC		; save it
	mov	R4, #1		; set the counter
	sjmp	_BTOA_3

_BTOA_1:
	mov	R4, #0		; zero the counter

_BTOA_2:
	mov	R1, #0Ah	; divisor
	lcall	_NDIV		; divide by 10
	push	_R1		; save the result
	inc	R4		; count it
	mov	A, R0		; are we done
	orl	A, R2
	jnz	_BTOA_2

_BTOA_3:
	mov	R1, #'0'	; the ASCII bias (30h)
	
_BTOA_4:
	pop	ACC		; get the ms digit
	add	A, R1		; convert to ASCII
	movx	@DPTR, A	; save it
	inc	DPTR
	djnz	R4, _BTOA_4	; are we done?
	
	clr	A		; the null terminator
	movx	@DPTR, A	; save it
_BTOA_OUT:
	ret

_NDIV:
	mov		R7, _R2			; move dividend into R7:R6
	mov		R6, _R0
	

	mov		R3, _R1			; store nibble divisor
	mov		R0, #_R7		; point to MS byte of dividend and eventual result
	mov		R1, #_R2		; R1 now a pointer to R2 so we can use nibble XCHD
	mov		A, R7			; get MS byte of dividend
	mov		B, R3			; put nibble divisor in B
	div		AB				; do the first division
	mov		R2, B			; move remainder to R2 so we can use XCHD in loop
	mov		R7, A			; MS byte now done, store in dividend/result
	dec		R0				; bump pointer to next MS byte
	
	mov		A, @R0			; get next byte of dividend in ACC
	xchd	A, @R1			; put remainder stored in R2 in LOW nibble of ACC
	swap	A				; mow remainder is in high nibble of ACC and next
							; MS nibble of dividendis in LOW nibble
	mov		B, R3			; divide again by divisor nibble
	div		AB
	mov		R2, B			; save remainder in R2
	swap	A				; put nibble result in high nibble and store in 
	xch		A, @R0			; DIVIDEND/RESULT while retrieving original
							; dividend byte (low nibble)
	swap	A				; LS nibble of dividend to hi nibble of ACC
	xchd	A, @R1			; remainder to low nibble of ACC
	swap	A				; swap remainder to high nibble for next divide
	mov		B, R3			; divide again by divisor nibble
	div		AB
	mov		R2, B			; save remainder in R2
	xchd	A, @R0			; store lo nibble result this byte in DIVIDEND/RESULT
	

	mov		R0, _R6			; return the results in OPREG0
	mov		R2, _R7
	mov		R1, B			; and the remainder from last divide in OPREG1
	ret
	
_ONEX1:
	mov	DPTR, #_INT_13_LOC	; get the address of _INT_13_LOC
	mov	A, R0	    		; save low byte of handler address
	movx	@DPTR, A
	inc	DPTR
	mov	A, R2	    		; save high byte of handler address
	movx	@DPTR, A
	setb	_ON_EX1	    		; flag that onex1 is active


  IF CPRINT
   	setb	IP.4			; set serial port int to high priority

	clr 	PX1			; set ex1 int to low priority


  ENDIF

  IF RTC
 	setb	PT0			; set RTC interrupt to high priority
  ENDIF

	orl 	IE, #84H 		; enable all interrupts and EX1 bit
	ret

_TIME_SET:
	mov	_RTC_SEC_LO, R0		; load the low byte of data from OPREG0
	mov	_RTC_SEC_HI, R2		; load the high byte of data from OPREG0
	ret	   			; done
		
_IMUL:
	mov		A, R3				; get OPREG1 sign
	rlc		A					; opreg1 sign in CARRY
	mov		A, R2				; get OPREG0 sign
	lcall	_OP_SIGNS			; adjust for the jump table
	push	ACC					; used to flag final compliment (if necessary)
	mov		DPTR, #_IMUL_1		; get the address of the jump table
	jmp		@A+DPTR				; jump from jump table
	
_IMUL_1:
	sjmp	_IMUL_3				; both values are positive
	sjmp	_IMUL_4				; OPREG0 negative, OPREG1 positive
	sjmp	_IMUL_6				; OPREG0 positive, OPREG1 negative
	
_IMUL_2:						; entry when both values are negative
	lcall	_I_TWOS_COMP_0		; two's compliment OPREG0

_IMUL_6:						; entry when OPREG0 positive, OPREG1 negative
	lcall	_I_TWOS_COMP_1		; two's compliment OPREG1

								; entry when one or both values are negative
								; the next test is specifically for both neg
	mov		A, R2				; special case test: Are both operands -32768?
	anl		A, R3				; ACC.7 set is both operands are -32768
	rlc		A					; put ACC.7 in carry
	jc		_IMUL_7				; continue to error

_IMUL_3:						; entry when both values are positive
	lcall	_UIMUL				; do the multiply
	mov		A, R2				; see if an overflow occured
	jnb		ACC.7, _IMUL_8		; if bit 15 clear no overflow occured
	rlc		A					; move bit 15 out of the way
	orl		A, R0				; see if result is 32768
	jnz		_IMUL_7				; if not zero, result is larger than 32768

	pop		ACC					; result is 32768
	jnb		P, _IMUL_9			; if no parity then this is an overflow
	ret							; else this is a negative result, so we're done

_IMUL_8:
	pop		ACC					; get the flag
	jnb		P, _IMUL_X			; if the ACC parity is even no compliment
	lcall	_I_TWOS_COMP_0		; return a negative product

_IMUL_X:
	ret							; done

_IMUL_4:						; entry when OPREG0 negative, OPREG1 positive
	lcall	_I_TWOS_COMP_0		; two's compliment OPREG0
	sjmp	_IMUL_3				; go do the multiply

_IMUL_7:
	dec		SP					; flush the stack

_IMUL_9:
	ljmp	_MATH_OVER			; jumps to error handling

_UIMUL:
	clr		C
	mov		A, R0					;	1. multiply R0 * R1
	mov		B, R1
	mul		AB
	
	mov		R4, A					;	2. move ACC to R4
	mov		R5, B					;	3. move B to R5
	
	mov		A, R1					;	4. multiply R1 * R2
	jz		_UIMUL_1					; jump to operation 7
	mov		B, R2
	mul		AB
	jb		OV, _UIMUL_3				; test for overflow
	
	add		A, R5					;	5. add R5 + ACC
	mov		R5, A					;	6. move ACC to R5
	
_UIMUL_1:
	mov		A, R3					;	7. multiply R3 * R0
	jz		_UIMUL_2
	mov		B, R0
	mul		AB
	jb		OV, _UIMUL_3			; test for overflow

_UIMUL_2:
	add		A, R5					;	8. add ACC + R5
	jc		_UIMUL_3
	mov		R2, A					;	9. move ACC to R2 (OPREG0 HI)
	mov		R0, _R4  				;	10. move R4 to OPREG0 LO
	ret

_UIMUL_3:
	setb	C						; here if we have overflowed
	ljmp	_MATH_OVER				; jump if error

_I_TWOS_COMP_1:
	clr		A			; setup
	clr		C
	subb	A, R1		; convert LSByte
	mov		R1, A		; save it
	clr		A			; setup
	subb	A, R3		; convert MSByte
	mov		R3, A		; save it
	clr		C
	ret					; done

;_%%MATH_ERRS:

_MATH_OVER:			; overflow
	IF  ERR_MSG 
		mov		DPTR, #_mathover_msg
	ENDIF
		mov A, #OVERFLOW
		ljmp _ERR_HAND

_MATH_DIV0:			; div by zero
	IF  ERR_MSG 
		mov		DPTR, #_mathdiv0_msg
	ENDIF
		mov A, #ZERO_DIVIDE
		ljmp _ERR_HAND


_MATH_BAD:			; bad argument
	IF  ERR_MSG 
		mov		DPTR, #_mathbad_msg
	ENDIF
		mov A, #BAD_ARGUMENT
		ljmp _ERR_HAND


;_%%MSEC:

_MSEC_GET:

	mov 	ACC, _RTC_MILLI		; get number of 5 msec ticks
	mov 	B, #5			; 5 msec per tick
	mul	AB
	mov	_R0, ACC		; result LSB
	mov	_R2, B			; result MSB
	ret


_MSEC_SET:
	mov	_R1, #5
	mov	_R3, #0
	lcall	_UIDIV			; get ticks in opreg0
	mov	_RTC_MILLI, _R0		; save ticks 
	ret
_UIDIV:
	clr		C
	mov		A, R1			; test for zero divisor
	orl		A, R3
	jnz		_UIDIV6
	setb	C				; divisor is zero; set carry
	ljmp	_MATH_DIV0		; jump if div by zero
	ret

_UIDIV6:
	mov		R7, #0			; zero the partial remainder
	mov		R6, #0
	mov		R4, #0			; zero quotient registers
	mov		R5, #0
	mov		B, #16			; load loop count
	
_UIDIV1:
	lcall	_UIDIV4			; shift the dividend and return MSB in C
	mov		A, R6			; shift carry into LSB of partial remainder
	rlc		A
	mov		R6, A
	mov		A, R7
	rlc		A
	mov		R7, A
							; now test to see if R7:R6 >= R3:R1
	clr		C
	mov		A, R7			; subtract R3 from R7 to see if R3 < R7
	subb	A, R3			; A = R7 - R3, carry set if R7 < R3
	jc		_UIDIV3	
							; at this point R7 > R3 or R7 = R3
	jnz		_UIDIV2			; jump if R7 > R3
							; if R7 = R3, test for R6 >= R1
	clr		C
	mov		A, R6
	subb	A, R1			; A = R6 - R1, carry set if R6 < R1
	jc		_UIDIV3
	
_UIDIV2:					; subtract the divisor from the partial remainder
	clr		C
	mov		A, R6
	subb	A, R1			; A = R6 - R1
	mov		R6, A
	mov		A, R7
	subb	A, R3			; A = R7 - R3 - borrow
	mov		R7, A
	setb	C				; shift 1 into the quotient
	sjmp	$+3
	
_UIDIV3:					; can't subtract so shift a zero into the quotient
	clr		C
	lcall	_UIDIV5			; shift the carry bit into the quotient
	djnz	B, _UIDIV1		; test for completion

	mov		_OPREG_0L, R4	; Now we are really done, move the quotient ...
	mov		_OPREG_0H, R5	; ... to OPREG0.

	mov		_OPREG_1H, R7	; ... and the remainder to OPREG1
	mov		_OPREG_1L, R6
	clr		C				; clear the carry flag
	ret						; done
	
_UIDIV4:
	; shift the dividend one bit to the left and return the MSB in C
	clr		C
	mov		A, R0
	rlc		A
	mov		R0, A
	mov		A, R2
	rlc		A
	mov		R2, A
	ret

_UIDIV5:
	mov		A, R4		; shift quotient one bit left and C into MSB
	rlc		A
	mov		R4, A
	mov		A, R5
	rlc		A
	mov		R5, A
	ret
	
_CLOCK_START:
	anl	TMOD,#0F0H		;set up the mode
	setb	_CLOCK_BIT		;set clock active flag
	orl	IE, #82H		;enable et0 and ea
	setb	TR0			;turn on the timer
	ret

_TIME_GET:
	mov	A, _RTC_SEC_HI			; high byte into accumulator
	mov	R0, _RTC_SEC_LO			; low byte into OPREG0
	cjne	A, _RTC_SEC_HI, _TIME_GET	; validate, repeat if upper byte changed
	mov	R2, A				; save final value
	ret					; done

_UIADD:
	setb	F0			; this means we're doing unsigned adds
	sjmp	_IADD_1		; now go do it

_IADD:
	clr		F0			; this means we're doing signed adds

_IADD_1:
	clr		C			; setup
	mov		A, R0		; add the low order bytes
	add		A, R1
	mov		R0, A		; save the result
	mov		A, R2		; add the high order bytes and propogate the carry
	addc	A, R3
	mov		R2, A		; save the result
	jbc		F0, _IADD_2	; skip next if we're doing unsigned adds
	mov		C, OV		; get overflow status of signed addition
	clr		OV

_IADD_2:
	jnc		_IADD_X
	ljmp	_MATH_OVER		

_IADD_X:
	ret

_TAB:
	mov	R1, #_PHEAD
	
    IF SPRINT
	jnb	_SPRT_FLAG, _TAB_SX
	mov	R1, #_SPHEAD
_TAB_SX:
    ENDIF

    IF UIO
	jnb	_UIO_OUT_FLAG, _TAB_UX
	mov	R1, #_UPHEAD
_TAB_UX:
    ENDIF

    IF UPRINT
	jnb	_UPRT_FLAG, _TAB_UPX
	mov	R1, #_UPHEAD
_TAB_UPX:
    ENDIF


_TAB_1:
	clr	C      			; clear the carry
	mov	A, R0			; get the column for next print into ACC
	subb	A, @R1			; compare against current print head position
	jc	_TAB2			; exit if print position is right of TAB position
	jz	_TAB2			; exit if at TAB position
	mov	@R1, _R0		; save new _PHEAD
	mov	R0, A			; save the delta between tab pos and _PHEAD
	mov	A, #32			; space character to ACC
	lcall	_REP_CHAR		; output characters until _PHEAD == tab
_TAB2:
	ret

_COR:
	mov		A, R0	; low byte of OPREG0
	orl		A, R1	; OPREG0L .OR. OPREG1L
	mov		R0, A	; save the result
	ret

_CAND:
	mov		A, R0	; low byte of OPREG0
	anl		A, R1	; OPREG0L .AND. OPREG1L
	mov		R0, A	; save the result
	ret

_RETI_BAS:

	pop	_R7
	pop	_R6
	pop	_R5
	pop	_R4
	pop	_R3
	pop	_R2
	pop	_R1
	pop	_R0
	pop	B
	pop	ACC

	pop	PSW	    		; get the F0 = ONTIME in progress flag
	jb F0, _RETI_ONTIME

_RETI_ONEX1:
	pop	DPH
	pop	DPL
	pop	PSW
	clr	_ON_EX1_INP		; not ontime, so was an onex1
	reti				; note is a reti for onex1

_RETI_ONTIME:
	pop	DPH
	pop	DPL
	pop	PSW
	clr _ON_TIME_INP		; clear ontime in process
	ret	  			; note not a reti for ontime
	
_end_module:		;end of this compiled module
	clr	_ON_TIME		;clear ONTIME flag
	lcall	_PRINT_DONE		;wait until print buffer empty
_END_AND_HALT:

	sjmp	$	

_ISTACK_CHECK:
	mov	A, #SPUSE		; max stack space we will use
	clr	C			; don't want to subtract the C
    IF ONEX1
    	jnb	_ON_EX1_INP, _CHK_ONEX1X	; not in handler -> jump
    	subb	A, #SPUSE_ONEX1		; we are, don't count its stack use
_CHK_ONEX1X:
    ENDIF

    IF ONTIME
    	jnb	_ON_TIME_INP, _CHK_ONTIMEX	; not in handler -> jump
    	subb	A, #SPUSE_ONTIME	; we are, don't count its stack use
_CHK_ONTIMEX:
    ENDIF
	mov	B, A			; save adjusted usage in B reg

	mov	A, SP
	cjne	A, _SPCLEAR, _ISTK_CHK2	; C set if SP < SPCLEAR

_ISTK_CHK2:
	jc	_ISTK_CHK_ERR		; SP < SPCLEAR is error, else...
					; ...SP >= SPCLEAR, so it's OK
	mov	A, #SPMAX		; SP upper limit (7FH or FFH)
	cpl	A			; now 00H for '32 or 80H for '31
	add	A, SP			; add current value
					; overflow not possible yet
	jc	_ISTK_CHK_ERR		; if overflowed, error
	add	A, B			; add most we'll need
	jc	_ISTK_CHK_ERR		; if overflowed, error
_ISTK_CHK_X:
	ret				; else OK so return

_ISTK_CHK_ERR:
	mov	SP, _SPCLEAR		; clear SP so we don't crash
	ljmp	_ISTACK_ERR2		; handle the error

_ISTACK_ERR2:			; Istack over or underflow 
	IF  ERR_MSG 
		mov		DPTR, #_istk_err_msg
	ENDIF
		mov A, #ISTACK_ERR		; the errval value
	 	ljmp	_ERR_HAND
_ERR_PRINT:

  IF CONSOLE_TIMER EQ 1
_ERR_PRINT2:	
  ENDIF
	push DPL			; save ptr to specific err msg
	push DPH
 	lcall _PUT_NEW_LINE
	mov DPTR, #_com_msg1
	lcall _PRINT_ROM		; output it
  IF PROGLINE
	lcall _ERR_LINE_PRT		; output failing line number 
  ENDIF
	pop DPH				; get ptr to specific err msg
	pop DPL
	lcall _PRINT_ROM		; output specific err msg
 	lcall _PUT_NEW_LINE



  IF CONSOLE_TIMER EQ 1
  ENDIF

_ERR_PRINTX:
	ret
_ERR_LINE_PRT:
  IF PROGLINE
	mov DPTR, #_com_msg2
	lcall _PRINT_ROM		; output '(LINE '
	mov DPTR, #_ERRLINE
	lcall _INT_GET			; errline in opreg0
	mov DPTR, #_pbuffer
	mov R1, DPL
	mov R3, DPH
	lcall _BTOA			; opreg0 convert to ascii
	mov DPTR, #_pbuffer
	lcall _PRINT 			; output line number
	mov DPTR, #_com_msg3
	lcall _PRINT_ROM		; output '): '
	ret
  ENDIF
_INT_GET:
	movx	A, @DPTR	; get the low byte
	mov	R0, A		; put it in OPREG0
	inc	DPTR
	movx	A, @DPTR	; get the high byte
	mov	R2, A		; put it in OPREG0
	ret			; done

_ERR_HAND:
    IF CHECK_MATH EQ 0
				; if not math checking, we ignore math errors
	cjne A, #40, $+3  	; was it a math error (C set iff val <40)?
	jnc $+3			; no, so proceed to handle it
	ret			; yes, do nothing and return 
    ENDIF
	push ACC		; push errval to save it
    IF PROGLINE
	push _R0		; push any math error value
	push _R2
	push ACC		; push errval to save it (again)
	push DPL		; save specific error message ptr
	push DPH
	mov DPTR, #_BASLINE	; update errline value
	lcall _INT_GET		; current line # in opreg0 (acc gets wasted)
	mov DPTR, #_ERRLINE
	lcall _INT_PUT		; save it in errline location
	pop DPH			; retrieve specific err msg ptr
	pop DPL
	pop ACC			; errval back in acc
    ENDIF

    IF ERR_MSG			; print message to console?
    	IF CHECK_MATH EQ 0
					; if not math checking, we ignore math errors
		cjne A, #40, $+3  	; was it a math error (C set iff val <40)?
		jc _ERR_HAND_MSGX  	; yes, jump past print
	ENDIF
	lcall _ERR_PRINT
	jb _CPRT_FLAG, $ 	; finish any printing
_ERR_HAND_MSGX:
    ENDIF

    IF PROGLINE
	pop _R2	 		; pop math error value back
	pop _R0	 		; in case we return
    ENDIF

	pop ACC			; pop errval back
	
  	mov DPTR, #_ERRVAL 	; update ERRVAL regardless of onerr
	movx @DPTR, A	   	; store ERRVAL

    IF ONERR				; save errval and jump to onerr code
  	jnb _ON_ERR, _ERR_ONERRX	; jump ahead if onerr inactive
	    IF CHECK_MATH EQ 0
					; if not math checking, we ignore math errors
 	   	cjne A, #40, $+3 	; was it a math error (C set iff val <40)?
	    	jc _ERR_ONERRX	 	; yes, jump past dispatcher
	    ENDIF
    	ljmp _ONERR_DISPATCH	; else jump to onerr handler, never to return
_ERR_ONERRX:
	ENDIF

	;
	; If here, onerr not active, run trap may be
	;

  IF (RUN_TRAP_LOC + RUN_TRAP_B52) EQ 0	; no run trap? so return or hang
	;
	; No run trap, so we can either hang or stagger on by returning
	; We test for certain errors on which to allow return
	;
	cjne A, #STRING_TRUNC, $+4	; was the error a string truncation?
	ret		; yes, return
    IF CHECK_MATH EQ 0
    	; if not math checking, we allow return on these errors
    	cjne A, #40, $+3		; was it a math error (C set iff val <40)?
    	jnc $+3				; no, jump to next test
    	ret				; yes, math error, so return
    ENDIF
    	cjne A, #MEM_ACC_B52, _ERR_HANG	; B52 istack or mtop conflict?
    	ret				; yes, return to whatever called it
_ERR_HANG:
	; Close any open interrupts
	;
	jnb _ON_EX1_INP, _ERR_HANG_2	; was onex1 in progress?
	jnb _ON_EX1_PND, _ERR_HANG_2	; was onex1 pending?
	mov DPTR, #_ERR_HANG_2	 	; if here, onex1 was in progress
	PUSH   DPL
	PUSH   DPH
	RETI   				; exit onex1 interrupt, pop PC to the DPTR value  
_ERR_HANG_2:
	clr	EA			; disable all interrupts
	sjmp 	$		 	; stay here forever or until wdog timeout
  ENDIF

  	;
  	; If here, one of the run traps is active
	; Close any open interrupts
	;
	clr	EA
	jnb _ON_EX1_INP, _ERR_HAND_2	; was onex1 in progress?
	jnb _ON_EX1_PND, _ERR_HAND_2	; was onex1 pending?
	mov DPTR, #_ERR_HAND_2		; if here, onex1 was in progress
	PUSH   DPL
	PUSH   DPH
	RETI   			; exit onex1 interrupt, pop PC to the DPTR value  

	;
	; Compiler only allows one of the run trap options active
	; If B52, local runtrap is placed differently than non-B52 case
	;
_ERR_HAND_2:
    IF (RUN_TRAP_LOC + RUN_TRAP_B52)
      IF (DS5000 + TARGET_8XC51F)
    	setb	F0		;
	mov	A, #0AAH	;
	mov	B, #055H	; This helps us detect a run trap at startup
      ENDIF
        IF RUN_TRAP_LOC		; ONERR not active, run trap in BCI51 code
     	mov SP, _SPCLEAR	; reset stack pointer
	ljmp _runtrap
	ELSE
     	ljmp _RET_B52		; return to B52, B52 assumed to run trap there
	ENDIF
    ENDIF

	clr	EA     		; disable all interrupts
    				; we can be here only due to runaway code since
				; run trap inactive was handled earlier, this
	sjmp $		 	; is here just as a precaution.

;_%%DALLAS_MSG:

	IF ERR_MSG

	ENDIF

_str0:	db	'Enter choice: 0=xby_pe, 1=set time, 2=set date, 3=on/off, 4=read 5=alarms ',0

_ongo_tbl4:
	dw	_B95
	dw	_B100
	dw	_B110
	dw	_B120
	dw	_B200
	dw	_B300
_str1:	db	'Enter an XBY PE address ',0
_str2:	db	'Enter new data ',0
_str3:	db	'XBY_PE@ ',0
_str4:	db	':',0
_str5:	db	'In 24 hour mode AM/PM value is not actually used',0
_str6:	db	'12/24 hr mode, (0=12) ',0
_str7:	db	'AMPM (0=AM) ',0
_str8:	db	'Hr, min, sec, hsec ',0
_str9:	db	'month, date, day, year ',0
_str10:	db	'Run, update, sqw ',0
_str11:	db	'Run=',0
_str12:	db	' update=',0
_str13:	db	' SQW=',0
_str14:	db	' CMD=',0
_str15:	db	' 12/24=',0
_str16:	db	' AMPM=',0
_str17:	db	' Day=',0
_str18:	db	'-',0
_str19:	db	'-',0
_str20:	db	'  ',0
_str21:	db	':',0
_str22:	db	':',0
_str23:	db	'.',0
_str24:	db	' ',0
_str25:	db	'RTC= ',0
_str26:	db	':',0
_str27:	db	'1=enable interval alarm, 0 disable interval alarm, 2 time of day alarm: ',0

_ongo_tbl48:
	dw	_B310
	dw	_B320
	dw	_B370
_str28:	db	'Interval alarm disabled!',0
_str29:	db	'Alarm interval SEC, HSEC ',0
_str30:	db	'Interval alarm will be at ',0
_str31:	db	':',0
_str32:	db	' when reading!',0
_str33:	db	'1=enable TOD alarm, 0 disable TOD alarm: ',0

_ongo_tbl57:
	dw	_B380
	dw	_B390
_str34:	db	'Time of day alarm disabled!',0
_str35:	db	'Day(1-7), Hour, Min alarm values: ',0
_str36:	db	'Enter alarm mask (min/hr/day 0,1,3,7) ',0
_str37:	db	'Time of day alarm enabled!',0
_str38:	db	'DS83_DAY_AL= ',0
_str39:	db	'DS83_HOUR_AL= ',0
_str40:	db	'DS83_MIN_AL= ',0
_str41:	db	'DS83_MASK_AL= ',0
_str42:	db	'Ontime Routine! SP max= ',0
_str43:	db	'Onex1! SP max= ',0
_str44:	db	'RUN= ',0
_str45:	db	' UPDATE= ',0
_str46:	db	' SQW= ',0
_str47:	db	'12/24= ',0
_str48:	db	' AMPM/24hrMSB= ',0
_str49:	db	'-',0
_str50:	db	'-',0
_str51:	db	' Day ',0
_str52:	db	' (Sun=1)  ',0
_str53:	db	':',0
_str54:	db	':',0
_str55:	db	'.',0
_str56:	db	' 24 hr mode',0
_str57:	db	' PM',0
_str58:	db	' AM',0
;_%%INP_MSG:

_str_val_big:	db	'Input Value Too Big',0
_str_val_err:	db	'Input Value Error',0
_str_val_neg:	db	'Input Value Negative',0

;_%%ONGO_MSG:
	IF (ERR_MSG)
_ongo_expr_neg:	db	'ON {expr} Negative',0
_ongo_expr_big:	db	'ON {expr} Too Big',0
	ENDIF

;_%%DS5ECC_STR:

_DS_AMPM_TAB:	DB 'AMPM',0

_DS_DAY_TAB:	DB 'SunMonTueWedThuFriSat',0

_DS_MON_TAB:	DB 'JanFebMarAprMayJunJulAugSepOctNovDec',0

;_%%MATH_MSG:

	IF ERR_MSG
_mathdiv0_msg:	db	'Divide by Zero',0
_mathover_msg:	db	'Math Overflow',0
_mathunder_msg:	db	'Math Underflow',0
_mathbad_msg:	db	'Math Argument Bad',0
	ENDIF

;_%%ISTACK_MSG:

	IF ERR_MSG
_istk_b52_msg:	db	'Istack/B52 Conflict',0
_istk_err_msg:	db	'Istack Error',0
	ENDIF

;_%%RELOC_MSG:

	IF ERR_MSG
_RELOC_MSG:	db	'Vector relocation FAILED',0
	ENDIF

;_%%COM_MSG:

	IF ERR_MSG
_com_msg1: db 'ERROR ',0
_com_msg2: db '(Line ',0
_com_msg3: db '): ',0

_bad_start: db 'STARTUP/RESET',0
	ENDIF


_cdataend:	; code space ends here
	org		32768		;data segment org 8000H


_databeg:	;data variable clear starts here

_udatabeg:	; user data clear starts here

__CHOICE5:	ds	1
__CHOICE4:	ds	1
__CHOICE3:	ds	1
__CHOICE2:	ds	1
__CHOICE1:	ds	1
__INTV_ALARM:	ds	1
__CHOICE:	ds	1
__KEY:	ds	1
__DAT:	ds	1
__ADDR:	ds	2
__SPTR:	ds	1

_udataend:	; user data clear stops just prior to here

;_%%LINENUM_DATA:

_BASLINE:	DS	2	; address of current BASIC line number (stored L:H)
_ERRLINE:	DS	2	; address of BASIC line number with error (stored L:H)

;_%%INT0B_DATA:

_INT_0B_LOC:	DS	2	; address of user's ONTIME routine (L:H)

;_%%INT23_DATA:
_FIFOBF:	DS	_FIFOLN	; GET and INT23 Buffer (number of 
				; typeahead keys we can remember)
_FIFOBE:	DS	1	; End of FIFOBF, MUST BE 1 FOR 1ST INC
_TALPTR:	DS	2	; Tail Pointer for input to _FIFOBF MSB:LSB
_HEDPTR:	DS	2	; Head Pointer for output from _FIFOBF

;_%%INPUT_DATA:

_INPBUF:	DS	_INPLEN	; Storage for the INPUT routine.
_INPBFE:	DS	2	; End of above Buffer, USED FOR NULL
_INPPTR:	DS	2	; Input Pointer for INPBUF

;_%%PRINT_DATA:

_OUTINP:	DS	2	; In Pointer
_OUTOTP:	DS	2	; Out Pointer



	IF _ALIGN

    IF (_ALIGN * (($ AND 0FF80h) NE (($ + _OUTLEN) AND 0FF80h)))
   	ORG	$ + (_OUTLEN - ($ + _OUTLEN) AND 007Fh)
    ENDIF

    	ENDIF

_OUTBUF:	DS	_OUTLEN	; Storage for OUTPUT buffer
_OUTBFE:	DS	1	; End of above Buffer

_STR_TOK_NXT:	ds	2
_STR_TOK_CUR:	ds	2
_pbuffer:	ds	8
;_%%DS1283_DATA:

_DS83_HSEC:	DS	1
_DS83_SEC:	DS	1
_DS83_MIN:	DS	1
_DS83_MIN_AL:	DS	1
_DS83_HOUR:	DS	1
_DS83_HOUR_AL:	DS	1
_DS83_DAY:	DS	1
_DS83_DAY_AL:	DS	1
_DS83_DATE:	DS	1
_DS83_MONTH:	DS	1
_DS83_YEAR:	DS	1
_DS83_CMD:	DS	1
_DS83_INTV_HSEC	DS	1
_DS83_INTV_SEC	DS	1
_DS83_MASK_AL	DS	1

_DS83_AMPM:	DS	1  		
_DS83_1224:	DS	1  		
_DS83_RUN:	DS	1  		
_DS83_SQW:	DS	1  		
_DS83_UPDATE:	DS	1  		
_DS83_AMPM$:	DS	3  		
_DS83_DAY$:	DS	4  		
_DS83_MONTH$:	DS	4  		

;_%%INT13_DATA:

_INT_13_LOC:	DS	2	; address of user's ONEX1 routine (L:H)

;_%%ERRVAL_DATA:
	IF (BASIC52 + BEBASIC)
						; ERRVAL already assigned via EQUATE 
	ELSE
_ERRVAL:		DS	1	; Location of the Error value
	ENDIF

_dataend:	; data variable clear ends here

; End of assembly file
	END  _START_LOC
