;*****************************************************************************
; This is a pretty exhaustive test program for the DS2251's on-board DS1283 
; Timekeeper chip.  Menu options prompt you for all the tests.
;
; If you have a DS2251-128, set the K2 loader range to 128 and partition to 0.
; If you have a smaller 2251, you may have to make other choices and/or move
; the code start up to the partition address if you use a "2250-like"
; partitioned memory map.
;
; Note that the #CHECK ISTACK configuration directive is disabled, since this
; check is usually too conservative in programs which have all possible
; interrupts active, on targets with only 128 bytes of internal RAM.  So we
; have turned it off here, but be warned that there is then no way to check if
; you ARE REALLY in danger of running out of stack space.
;
; If you use #PRINT COMPLETE OFF your program will use about 10 more bytes of
; internal stack space than with PRINT COMPLETE ON (the default).  If the print
; buffer ever fills completely, the processor can use up to 20 more bytes of
; stack space as it waits for the buffer to empty.  One way to get the buffer
; to fill is to send your target hardware a Control-S (X-OFF).  Printing a
; lot of characters at a low baud rate will do it also.
;
; Avoid more than 2 sets of nested parentheses if (1) you are on a 128-byte
; internal memory processor, (2) have all interrupts active and (3) print 
; complete off. Break nested expressions into multiple statements separated 
; by colons.
;
;
; REVISION HISTORY -----------------------------------------------------------
;
;  03/29/94	BAB	Added AM/PM text display, improved status routine
;
;
; DESIRED MODIFICATIONS ------------------------------------------------------
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; If you will be reading several different timekeeper values for example,
; hours and minutes, there is a possibility that one could change while you
; are reading the other.  For example if the time is 8:59 you could read the 
; minutes as 59 and then they could roll over just before you read the hour
; which would now be 9, so you'd get the time as 9:59 when it was really 9:00.
;
; To prevent this, just turn off DS83_UPDATE, read the values, and then turn 
; update back on.  Remember update does not stop the timekeeper, it just
; freezes its output register values.
;
;*****************************************************************************

;-----------------------------------------------------------------------------

#target DS2251T
#data start 8000H
#code start 0H
#console mode=9600
#run trap local
#print complete off
#check math off		; for RTC overflow to not cause math overflow
#check istack off	; too conservative for this program

unsigned char SPTR	; the stack pointer
unsigned int addr
unsigned char dat, key, choice, intv_alarm
unsigned char choice1, choice2, choice3, choice4, choice5

90 CLOCK0 : CLEARI : ? 
	gosub status_print

92 INPUT "Enter choice: 0=xby_pe, 1=set time, 2=set date, 3=on/off, 4=read 5=alarms ", choice
	: on choice goto 95, 100, 110, 120, 200, 300

95 Input "Enter an XBY PE address ", addr
	: gosub 98
	: Input "Enter new data ", dat
	: DS_XBY_PE(addr) = dat
	: gosub 98
	: goto 90

98 PH0. "XBY_PE@ ",addr, ":", DS_XBY_PE(addr)	; subr for xby_pe display
	: return

100 ? "In 24 hour mode AM/PM value is not actually used"
	: Input "12/24 hr mode, (0=12) ", choice1
	: DS83_1224 = choice1
	if DS83_1224 = 0 then
		Input "AMPM (0=AM) ", choice2
		DS83_AMPM = choice2
	endif

105 INPUT "Hr, min, sec, hsec ", choice1, choice2, choice3, choice4
	: DS83_HOUR = choice1
	: DS83_MIN = choice2
	: DS83_SEC = choice3
	: DS83_HSEC = choice4
109 goto 90

110 INPUT "month, date, day, year ",  choice2, choice3, choice4, choice5
	: DS83_MONTH = choice2
	: DS83_DATE = choice3
	: DS83_DAY = choice4
	: DS83_YEAR = choice5
119 goto 90

120 INPUT "Run, update, sqw ", choice1, choice2, choice3
	DS83_RUN = choice1
	DS83_UPDATE = choice2
	DS83_SQW = choice3
	goto 90

200 REM Continuously read the Timekeeper
	: ? "Run=", DS83_RUN, " update=", DS83_UPDATE, " SQW=", DS83_SQW, 
	: PH0. " CMD=", DS83_CMD, 
	: ? " 12/24=", DS83_1224, " AMPM=", DS83_AMPM, " Day=", DS83_DAY
	: if intv_alarm = 0 then goto 201 : else ONEX1 700
201 CLOCK0 : DS83_UPDATE=0 : TIME=DS83_SEC : MSEC=DS83_HSEC*10 :DS83_UPDATE=1
	: CLOCK1 : ONTIME TIME+10, 600
202 DS83_UPDATE=0 
	: ? DS83_MONTH,"-",DS83_DATE,"-",DS83_YEAR, "  ",
210 ? DS83_HOUR,":",DS83_MIN,":",DS83_SEC,".",DS83_HSEC, " ", 
	: DS83_UPDATE=1
	: ? tab(22),"RTC= ",TIME,":",MSEC, CR,
230 key = get : if key=0 then goto 202	; advance w/any key press, else loop
299 goto 90


300 REM Alarm choices
305 INPUT "1=enable interval alarm, 0 disable interval alarm, 2 time of day alarm: ", choice
	: on choice goto 310, 320, 370

310 REM Disable
	: DS83_INTV_HSEC = 0	; interval of 0 disables
	: DS83_INTV_SEC = 0	; 
	: intv_alarm = 0
	: ?"Interval alarm disabled!"
	: goto 90

; Tie INTB output from DS2251 to its ONEX1 input for this test:
320 DS83_CMD = 0D0H		; intB = interval pulsed low
	: TCON = TCON OR 040H	; onex1 is falling edge sensitive
	: INPUT "Alarm interval SEC, HSEC ", choice1, choice2
	: DS83_INTV_SEC = choice1	; set up interval
	: DS83_INTV_HSEC = choice2
	: intv_alarm = 1
	: ?"Interval alarm will be at ", 
		: ? DS83_INTV_SEC,":",DS83_INTV_HSEC, " when reading!"

359 goto 90

370 REM Time of day alarm options
371 INPUT "1=enable TOD alarm, 0 disable TOD alarm: ", choice
	: on choice goto 380, 390
380 REM Disable TOD alarm
	: DS83_CMD = DS83_CMD OR 04H	; set TOD mask bit to disable
	: ? "Time of day alarm disabled!"
	: goto 90

390 REM Enable TOD alarm
	: DS83_CMD = DS83_CMD AND 0F8H	; clr TOD mask bit to enable
	: INPUT "Day(1-7), Hour, Min alarm values: ", choice1, choice2, choice3
	: DS83_DAY_AL = choice1
	: DS83_HOUR_AL = choice2
	: DS83_MIN_AL = choice3
	: INPUT "Enter alarm mask (min/hr/day 0,1,3,7) ", choice
	: DS83_MASK_AL = choice
	: ? "Time of day alarm enabled!"
395	? "DS83_DAY_AL= ",DS83_DAY_AL 
	: ? "DS83_HOUR_AL= ",DS83_HOUR_AL 
	: ? "DS83_MIN_AL= ",DS83_MIN_AL 
	: ? "DS83_MASK_AL= ",DS83_MASK_AL 
399 goto 90


600 REM Ontime routine
#ASM
	lcall _SPTR
#ASM_END
610 ? : ? "Ontime Routine! SP max= ", SPTR
620 ONTIME TIME+1, 600
699 RETI

700 REM Onex1 routine
#ASM
	lcall _SPTR
#ASM_END
710 ? : ? "Onex1! SP max= ", SPTR
799 RETI



998
#ASM
	; written to help catch istack errors
	; saves max value of SP in the BASIC var SPTR
_SPTR:
	mov DPTR, #__SPTR	; point to BASIC var SPTR
	movx A, @DPTR		; current SPTR value
	cjne	A, SP, _SP2	; C set if A < SP
_SP2:
	jnc _SPX		; jmp if current SPTR is >= SP
	mov A, SP		; else get current SP value
	movx @DPTR, A		; save in variable location
_SPX:
	ret

#ASM_END

999 END

status_print:
	? "RUN= ", DS83_RUN, " UPDATE= ", DS83_UPDATE, " SQW= ", DS83_SQW
	? "12/24= ", DS83_1224, " AMPM/24hrMSB= ", DS83_AMPM
	? DS83_MONTH,"-",DS83_DATE,"-",DS83_YEAR, " Day ", DS83_DAY," (Sun=1)  ",
	? DS83_HOUR,":",DS83_MIN,":",DS83_SEC,".",DS83_HSEC,
	if DS83_1224 then
		? " 24 hr mode"
	else
		; if not 24 hour mode, then ampm bit is significant
		if DS83_AMPM then ? " PM" else ? " AM"
	endif
	return
