;-----------------------------------------------------------------------------
; Sample program for 2x24 LCD and DS5000 or 2250 targets
; Not for 2251 or 2252!  The Timekeepers are different.
;
; 01-13-94	BAB	Added PRINT# to test printer output
;-----------------------------------------------------------------------------

#target DS2250T
#console mode=9600
#printer mode=9600
#code start 0h
#data start 6000H
; check math must be off to avoid math overflow when TIME approaches
; 65535 and we're adding to it
#check math off

; Sample code for driving a 2x24 LCD
;
; LCD CONTROL
;
; P1.4 is LCD R/S, H for data, L for instr
; P1.5 is LCD RD (H), write is L
; P1.6 is LCD EN, pulse it H to strobe the cycle into the LCD
;
; P0 is the data bus
; Busy flag is data bit 7, P0.7
;

unsigned char LCD_DAT
signed int x
unsigned int TIME_TMP, WAIT_SEC, MSEC_TMP

#include "relay1.inc"

100 REM Clear Display
101 gosub 1000	     ; software init

    ; enable clock time update
    TIME = 0 : MSEC = 0 : CLOCK1


200 REM Now send some data
	: ? : ? "Sending data..."

285	LCD_DAT = 080H : gosub 1010		; set to top row addr=000H
REM               0	    1			; addr=0 dec, chars 0-23
REM               012345678901234567890123
	: print@ "Greetings & Salutations ",
	: print# "Greetings & Salutations ",

	: LCD_DAT = 0C0H : gosub 1010		; set to 2nd row addr=040H
REM               012345678901234567890123
	: print@ "from Bruce at Systronix!",
	: print# "from Bruce at Systronix!"

	wait_sec=1

	print "Starting main loop"



display_shift:
	;
	; note that the 2x24 only has 24 chars of display RAM per line
	; but each line is 40 chars long!
	; so a complete circular shift takes 40 chars, 16 of which are blank
	;
	gosub waitsec
	for x= 1 to 40
	msec=0 : do : while msec<200
	LCD_DAT = 018H : gosub 1010		; shift display left
	next x

	gosub waitsec
	for x= 1 to 40
	msec=0 : do : while msec<200
	LCD_DAT = 01CH : gosub 1010		; shift display right
	next x


	LCD_DAT = 080H : gosub 1010		; set to top row addr=000H
REM             0	    1			; addr=0 dec, chars 0-23
REM             012345678901234567890123
	print@ " Easy Embedded Control! ",
	LCD_DAT = 0C0H : gosub 1010		; set to 2nd row addr=040H
	print@ "                        ",

	time=0 : ONTIME 2, timer_tick

stay:
	goto stay


999 END

1000 ? "Clearing Display..."
	: clock1 : msec=0 : do : while (msec < 20) 
	: PORT0 = 030H 
		: msec=0 : do : while (msec < 5)
	: gosub 1016
	: PORT0 = 030H : msec=0 : do : while (msec < 5)
	: gosub 1016
	: PORT0 = 030H 
		: msec=0 : do : while (msec < 5)
	: gosub 1016
	: PORT0 = 030H 
		: msec=0 : do : while (msec < 5)

	; set interface to 8 bits, 1 line display
	; 030H = 8 bits, one line, 5x7 font
	; 038H = 8 bits, 2 lines, 5x7 font
	: PORT0 = 038H 
	: gosub 1016

	; Turn on display
	; 0FH = cursor on and blinking
	; 0CH = no cursor
	: PORT0 = 0CH
	: gosub 1016

	; clear display, cursor home
	: PORT0 = 01H
	: gosub 1016

	: return


1010 REM strobe instr, call here to use LCD_DAT
1015 PORT0 = LCD_DAT
1016 REM call here with your own data
#ASM
	CLR	P1.4	; set R/S low for instr
	CLR 	P1.5	; set WR low
	CLR	P1.6	; clear enable
	SETB	P1.6	; strobe it
	CLR	P1.6	; clear enable

	mov	B, #40	;
	DJNZ	B, $	; wait about 40 usec
#ASM_END
1019	return


1100 REM data write, call here to use LCD_DAT
1105 PORT0 = LCD_DAT
1106 REM call here with your own data already on PORT0
#ASM
	SETB	P1.4	; set R/S high for data
	CLR 	P1.5	; set WR low
	CLR	P1.6	; clear enable
	SETB	P1.6	; strobe it
	CLR	P1.6	; clear enable

	mov	B, #50	;
	DJNZ	B, $	; wait about 40 usec
#ASM_END
1119	return


WAITSEC:
	TIME_TMP= TIME + WAIT_SEC : MSEC_TMP = MSEC 
	DO : UNTIL ( ( TIME = TIME_TMP) AND (MSEC = MSEC_TMP))
	return


timer_tick:
    ontime time+1, timer_tick
    gosub update_time
    gosub relay_test
    RETI

REM update time on bottom line
update_time:
    DS_ECC_RD
    gosub metronome_1

update_time_disp:
	LCD_DAT = 0C0H : gosub 1010		; set to 2nd row addr=040H
	print@ " * ",
	IF DS_MONTH < 10 then print@ "0",
	print@ DS_MONTH, "-",
	IF DS_DATE < 10 then print@ "0",
	print@ DS_DATE, "-", DS_YEAR, "  ",
	IF DS_HOUR < 10 then print@ "0",
	print@ DS_HOUR, ":",
	IF DS_MIN < 10 then print@ "0",
	print@ DS_MIN, ":",
	IF DS_SEC < 10 then print@ "0",
	print@ DS_SEC, " * ",
	return


relay_test:
	; Turn relays 2,3,4 on sequentially then all off then repeat
	; Don't touch relay 1 since it is the metronome

	if (relay_number > 4 or relay_number = 0) then 
		gosub relay_init	; turn all off
	    	relay_number = 2	; for next time
		return			
	else
		gosub relay_turn_on
		print "Relay ", relay_number, " on!"
	    	relay_number = relay_number + 1	; for next time
	endif
		return
	

END
