;-----------------------------------------------------------------------------
; INPUT DATA VIA KEYPAD INCLUDE FILE FOR USE WITH DPB2 REV D or E
;
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
;		Systronix, Inc. Salt Lake City, Utah, USA
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who have the pleasure of using 
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; suffix soft microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above.
;
;
; REVISION HISTORY -----------------------------------------------------------
;
;	03/02/94	BAB	Added new header, released in ZIP file
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; Data entry routines for keypad and LCD
;
;-----------------------------------------------------------------------------
;

    goto inp_inc_end            ; protect against include in program body
    
    signed int inp_dat
    unsigned char inp_dat_status
    unsigned char inp_dat_len

    string inp_dat_str$(10)
    unsigned char inp_dat_strlen
    

REM get a number from the keypad into inp_dat using the value in inp_dat as
REM a default
REM maximum length of number should be passed in inp_dat_len
REM status of number is returned in inp_dat_status
REM     = -1 for ok
REM     = 0 for aborted
REM while waiting for key
inp_get_num:
    inp_dat = 0
    inp_dat_status = 0
    inp_dat_strlen = 0
/*
#ASM
	mov		DPTR, #__INP_DAT_STR$
	mov		R1, DPL
	mov		R3, DPH
	mov     DPTR, #__INP_DAT
	movx	A, @DPTR
	mov		R0, A
	inc		DPTR
	movx	A, @DPTR
	mov		R2, A
	lcall	_ITOA
#ASM_END
*/
get_key_loop:
    gosub key_get_key
    if (key_dat <> 0FFh) then 
        if (key_dat >= 0) and (key_dat <= 09h) then
            ; numeric key
            print@ key_dat,
            inp_dat_strlen = inp_dat_strlen + 1
        else
            ; control key
            if (key_dat = 011H) then goto inp_exit_bad
            if (key_dat = 012H) or (key_dat = 014H) then goto inp_exit_good
            if (key_dat = 013H) then        ; left
                if (inp_dat_strlen > 0) then
                    inp_dat_strlen = inp_dat_strlen + 1
                    gosub lcd_get_dd_pos        ; get current position
                    lcd_dat = lcd_dat - 1       ; decrement and move one to left
                    gosub lcd_set_dd_pos      
                    print@ " ",                 ; write a space
                    gosub lcd_set_dd_pos        ; go back one space
                else
                    gosub beep_1
                endif
            endif
            if (key_dat = 015H) then gosub beep_1; right
        endif
    endif
    ; do other update work here
    goto get_key_loop

inp_exit_good:
    inp_dat = inp_dat*10 + key_dat
    inp_dat_status = -1
inp_exit_bad:
    return


inp_inc_end:                    ; protect against include in program body
