;-----------------------------------------------------------------------------
;
; KEYPAD INCLUDE FILE for DPB2 board rev E
;
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
;		Systronix, Inc. Salt Lake City, Utah, USA
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who have the pleasure of using 
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; suffix soft microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above.
;
; REVISION HISTORY -----------------------------------------------------------
;
;	95 Feb 22 BAB	Changed much BASIC into in line assy code for faster
;			execution and smaller size.  Improved comments to help
;			understand keypad mapping.
;
;	03/25/94	BAB	Fixed up arrow / left arrow: now are correctly mapped,
;					left arrow is a raw 01H, up arrow a raw 00H
;	03/02/94	BAB	Added new header, released in ZIP file
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; Keypad control
; Keypad output enable is P1.3
; Keypad interrupt goes high when a key is pressed and then low
; when released.  This is wired to the Dallas INT1 input.
; If TCON.2 is set to a 1, a key press will cause an INT1 on its
; falling edge, i.e., when the key is released.
;
; To read the value of the key, drive P1.3 low and read the data on the PORT0
; data port.
;
;-----------------------------------------------------------------------------

	goto key_inc_end		; protect against include in program body
    
	unsigned char key_dat, key_raw

	REM get key value and put in KEY_DAT
key_get_data:
	PORT0 = 0FFH			; make Port0 input
	PORT1 = PORT1 AND 0F7H		; clear P1.3 to read keypad data
	key_dat = PORT0
	PORT1 = PORT1 OR 008H		; set P1.3 to take C922 off the data bus!
	key_dat = key_dat AND 00FH	; mask off upper nibble
	key_raw = key_dat
	return


key_get_val:
    	gosub key_get_data
#ASM
	mov	DPTR,#__KEY_DAT		; addr in DPTR
	movx    A,@DPTR			; put value into acc
	add     A,#02H			; adjust for jump
	movc    A,@A+PC			; get lookup value into acc
	sjmp    OVER_KEY_TABLE		; jump over data
	;---------------------------------------------------------------------
	; Lookup Data Entries and change to our desired key map
	;
	; Note that the 0th entry in the table is raw key value 0
	; and the nth table entry is raw key value n.
	;
	; This translates Systronix keypad 100222 into the keys used
	; in our HPC2 and DPB2 systems.  Note that pin 1 of the keypad 
	; connector is the rightmost pin as you face the keypad with 
	; the flex cable extending away from you, out of the top of the keypad.
	; The Systronix keypad layout from top to bottom and left to right is:
	; 	7 	8 	9 	{left arrow}
	; 	4 	5 	6 	{up arrow}
	; 	1	2	3	{down arrow}
	;	ESC	0	.	{enter}
	;
	; So we want the keypad handler to return the value of the key pressed,
	; i.e., a 1 if the number 1 key is pressed, an 8 for the number 8 key
	; and so on.  Non-numeric keys return 1XH such as 14H for up arrow, so
	; if the key value returned is greater than 09H we know its a non-numeric
	; key.  This convention makes it easy to separate numeric from non-numeric
	; keys in your BASIC program.
	;
	;
	DB      14H			; raw 00H - our up arrow
	DB      15H			; raw 01H - our del/backspace
    	DB      13H			; raw 02H - our down arrow
    	DB      12H			; raw 03H - our enter key
    	DB      06H			; raw 04H - our number 6
    	DB      09H			; raw 05H - our number 9
    	DB      03H			; raw 06H - our number 3
    	DB      11H			; raw 07H - our dec point
	DB      05H			; raw 08H - our number 5
    	DB      08H			; raw 09H - our number 8
	DB      02H			; raw 0AH - our number 2
    	DB      00H			; raw 0BH - our number 0
    	DB      04H			; raw 0CH - our number 4
    	DB      07H			; raw 0DH - our number 7
	DB      01H			; raw 0EH - our number 1
	DB      10H			; raw 0FH - our escape key
OVER_KEY_TABLE:
	movx    @DPTR,A			; store value in KEY_DAT
#ASM_END
	return

key_inc_end:				; protect against include in program body
