;-----------------------------------------------------------------------------
;
; DEMO PROGRAM for DPB2 REVE
;
; LCD162.BAS
;
; Sample program for 16x2 LCD and DS5000 or 2250 targets
; Not for use with DS2251/2 which have a different Timekeeper.
;
; (C) Copyright 1994 Systronix, Inc All Rights Reserved
;		Systronix, Inc. Salt Lake City, Utah, USA
;		TEL: 801-534-1017  FAX:801-534-1019  BBS:801-487-2778
;
; Owners of Systronix products are hereby entitled to use, modify, and copy
; this sample program.  You may incorporate all or part of this program in 
; your own commercial products provided they are not simply copies of 
; Systronix products and do not compete directly with Systronix products.  
; This program is provided by Systronix free of charge and may not be resold.
;
; This program is intended for those of you who have the pleasure of using 
; the new DPB2 REVE board from Systronix/Intellix.  This card is a very
; easy to use development system for the Dallas DS5000/1/2 DS2250/1/2 and -T
; suffix soft microcontrollers.  If you'd like more information, please call
; or FAX us at the numbers above.
;
; REVISION HISTORY -----------------------------------------------------------
;
; 03-04-94	BAB	Taken from HELLO242.BAS
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
; 16x2 LCD has LED backlight pins swapped relative to the 20x4 LCD.
; The 16x2 LED+ is towrd the bottom edge of the display, away from the row
; of 14 contacts.
;
; Also the 16x2 LCD has a built in 27 ohm current limit resistor, so the
; DPB2E R6 can be removed.
;
;
;-----------------------------------------------------------------------------
;
; 
;
;
;-----------------------------------------------------------------------------

#target DS2250T
#console mode=9600
#printer mode=9600
#code start 0h
#data start 6000H
; check math must be off to avoid math overflow when TIME approaches
; 65535 and we're adding to it
#check math off

; Sample code for driving a 16x2 LCD
;
; LCD CONTROL
;
; P1.4 is LCD R/S, H for data, L for instr
; P1.5 is LCD RD (H), write is L
; P1.6 is LCD EN, pulse it H to strobe the cycle into the LCD
;
; P0 is the data bus
; Busy flag is data bit 7, P0.7
;

unsigned char LCD_DAT, date_time, top
signed int x
unsigned int TIME_TMP, WAIT_SEC, MSEC_TMP

#include "rly_e.inc"

100 REM Clear Display
101 gosub 1000	     ; software init

    ; enable clock time update
    TIME = 0 : MSEC = 0 : CLOCK1

	DS_ECC_RD					; get current time
	DS_ECC_RUN = 1
	DS_ECC_WR					; be sure ECC is running


200 REM Now send some data
	: ? : ? "Sending data..."

285	LCD_DAT = 080H : gosub 1010			; set to top row addr=000H
REM           0	        1				; addr=0 dec, chars 0-16
REM           0123456789012345	
	print@ "NEW! SYSTEM DPB2",
	print# "New DPB2 rev E ",

	LCD_DAT = 0C0H : gosub 1010			; set to 2nd row addr=040H
REM           0123456789012345
	print@ " from Systronix ",
	print# "from Systronix!"

	wait_sec=2
	gosub waitsec

	print "Starting main loop"


display_shift:
	;
	; note that the 16x2 only has 16 chars of display RAM per line
	; but each line is 40 chars long!
	; so a complete circular shift takes 40 chars, 24 of which are blank
	;
	gosub waitsec
	for x= 1 to 16
	msec=0 : do : while msec<200
	LCD_DAT = 018H : gosub 1010			; shift display left
	next x

	for x= 1 to 16
	msec=0 : do : while msec<200
	LCD_DAT = 01CH : gosub 1010			; shift display right
	next x

	gosub waitsec

	time=0 : ONTIME 2, timer_tick

stay:
	goto stay


999 END

1000 ? "Clearing Display..."
	: clock1 : msec=0 : do : while (msec < 20) 
	: PORT0 = 030H 
		: msec=0 : do : while (msec < 5)
	: gosub 1016
	: PORT0 = 030H : msec=0 : do : while (msec < 5)
	: gosub 1016
	: PORT0 = 030H 
		: msec=0 : do : while (msec < 5)
	: gosub 1016
	: PORT0 = 030H 
		: msec=0 : do : while (msec < 5)

	; set interface to 8 bits, 1 line display
	; 030H = 8 bits, one line, 5x7 font
	; 038H = 8 bits, 2 lines, 5x7 font
	: PORT0 = 038H 
	: gosub 1016

	; Turn on display
	; 0FH = cursor on and blinking
	; 0CH = no cursor
	: PORT0 = 0CH
	: gosub 1016

	; clear display, cursor home
	: PORT0 = 01H
	: gosub 1016

	: return


1010 REM strobe instr, call here to use LCD_DAT
1015 PORT0 = LCD_DAT
1016 REM call here with your own data
#ASM
	CLR	P1.4	; set R/S low for instr
	CLR	P1.5	; set WR low
	CLR	P1.6	; clear enable
	SETB	P1.6	; strobe it
	CLR	P1.6	; clear enable

	mov	B, #40	;
	DJNZ	B, $	; wait about 40 usec
#ASM_END
1019	return


1100 REM data write, call here to use LCD_DAT
1105 PORT0 = LCD_DAT
1106 REM call here with your own data already on PORT0
#ASM
	SETB	P1.4	; set R/S high for data
	CLR 	P1.5	; set WR low
	CLR	P1.6	; clear enable
	SETB	P1.6	; strobe it
	CLR	P1.6	; clear enable
	mov	B, #50	;
	DJNZ	B, $	; wait about 100 usec
#ASM_END
1119	return


WAITSEC:
	TIME_TMP= TIME + WAIT_SEC : MSEC_TMP = MSEC 
	DO : UNTIL ( ( TIME = TIME_TMP) AND (MSEC = MSEC_TMP))
	return


timer_tick:
    ontime time+1, timer_tick
	if date_time > 5 then 
		gosub date_disp 
	else 
		gosub time_disp
	endif

	if date_time > 10 then date_time = 0 else date_time = date_time + 1

	if top>=5 then top = 0 else top = top + 1

	on top gosub lcdtop1, lcdtop1, lcdtop2, lcdtop2, lcdtop3, lcdtop3

    gosub relay_test
    RETI

;-----------------------------------------------------------------------------
; Date and time display, with 16 chars no space between date & time:
; on LCD line 2
;
; 0123456789012345
; MM-DD-YYHH:MM:SS
;
date_time_disp:
    DS_ECC_RD
    gosub metronome_1

	LCD_DAT = 0C0H : gosub 1010		; set to 2nd row addr=040H
	IF DS_MONTH < 10 then print@ "0",
	print@ DS_MONTH, "-",
	IF DS_DATE < 10 then print@ "0",
	print@ DS_DATE, "-", DS_YEAR, 
	IF DS_HOUR < 10 then print@ "0",
	print@ DS_HOUR, ":",
	IF DS_MIN < 10 then print@ "0",
	print@ DS_MIN, ":",
	IF DS_SEC < 10 then print@ "0",
	print@ DS_SEC,
	return


;-----------------------------------------------------------------------------
; Date display
;
; 0123456789012345
; DATE: MM-DD-19YY
;

date_disp:
    DS_ECC_RD
    gosub metronome_1

	LCD_DAT = 0C0H : gosub 1010		; set to 2nd row addr=040H
	print@ " DATE: ",
	IF DS_MONTH < 10 then print@ "0",
	print@ DS_MONTH, "-",
	IF DS_DATE < 10 then print@ "0",
	print@ DS_DATE, "-", DS_YEAR, " ",
	return


;-----------------------------------------------------------------------------
; Time display
;
; 0123456789012345
; TIME: HH:MM:SS
;

time_disp:
    DS_ECC_RD
    gosub metronome_1

	LCD_DAT = 0C0H : gosub 1010		; set to 2nd row addr=040H
	print@ " TIME: ",
	IF DS_HOUR < 10 then print@ "0",
	print@ DS_HOUR, ":",
	IF DS_MIN < 10 then print@ "0",
	print@ DS_MIN, ":",
	IF DS_SEC < 10 then print@ "0",
	print@ DS_SEC,"  ",
	return


LCDTOP1:
	LCD_DAT = 080H : gosub 1010		; set to top row addr=000H
REM         0	      1				; addr=0 dec, chars 0-23
REM         0123456789012345
	print@ " SYSTRONIX DPB2 ",
	return

LCDTOP2:
	LCD_DAT = 080H : gosub 1010		; set to top row addr=000H
REM         0	      1				; addr=0 dec, chars 0-23
REM         0123456789012345
	print@ "  QUICK & EASY  ",
	return

LCDTOP3:
	LCD_DAT = 080H : gosub 1010		; set to top row addr=000H
REM         0	      1				; addr=0 dec, chars 0-23
REM         0123456789012345
	print@ "EMBEDDED CONTROL",
	return


relay_test:
	; Turn relays 2,3,4 on sequentially then all off then repeat
	; Don't touch relay 1 since it is the metronome

	if (relay_number > 4 or relay_number = 0) then 
		gosub relay_init	; turn all off
	    	relay_number = 2	; for next time
		return			
	else
		gosub relay_turn_on
		print "Relay ", relay_number, " on!"
	    	relay_number = relay_number + 1	; for next time
	endif
		return
	

END
