;-----------------------------------------------------------------------------
;	1283_CLR.ASM
;
; This program clears & disables the DS1283 RTC INTP output, and
; disables the alarm interrupts.
;
; PURPOSE --------------------------------------------------------------------
;
; When the 1283 timekeeper powers up from a completely unpowered condition, its
; internal bits are in a random but sometimes undesirable state. This can
; include driving the INTP output forever. On the DS2252T, INTP is tied to
; interrupt 0. DS2252Ts are shipped in a "freshness" state with the battery
; disconnected to preserve its life while the part is new and sitting on the
; shelf. We have seen such new parts power up with INT0 pulled low, even after
; starting and initializing the 1283 clock and calendar. This can appear to be
; a defective part with INT0 (P3.2) unable to be pulled high.
;
; This code is only necessary on parts which have been taken out of freshness
; or had their backup voltage interrupted by some other means.
;
; Run this program once, and the part will be OK forever as long as the
; DS1283's backup voltage remains stable.
;
; REVISION HISTORY -----------------------------------------------------------
;
; 96 Sep 23 BAB	Taken from Kevin Self's code
;
;
; NOTES AND COMMENTS ---------------------------------------------------------
;
;
; Note: the high bit of reg 08 is INP, if set this drives INT0/P3.2
; on the DS2252T low forever. After an initial 1st time power up,
; YOU CANNOT BELIEVE the value of register 08H. If it reads that
; the bit 7 is clear it can still actually be set! For example we
; often read the value 26H from reg 08, which means bit 7 is OFF. But
; INTP is still being driven low. Then we write 26H (yes the same
; data we read) to reg 08
;
;-----------------------------------------------------------------------------

MCON    EQU     0C6H           ;Equate MCON to C6h.
        org 0
        sjmp 33h

        
        org 33h

START:
        MOV     P2,     #00H    ;Clear high byte of address.
	PUSH	MCON		;Save current MCON settings.
	ORL	MCON,	#04H	;Switch to PES to access DS1283

	; Register 0BH
	; Bit 7 - TE : Transfer enable, a 1 enables RTC register updates
	; Bit 3 - WAM: watchdog alarm mask, 1 disables
	; Bit 2 - TDM: time of day alarm mask, 1 disables
	; Bit 1 - WAF: read only, 1 means watchdog alarm has occurred
	MOV	R0,	#0BH	;Disable watchdog, TOD interrupts, set TE bit.
	MOV	A,	#8CH
	MOVX	@R0,	A

	; 1283 Register address 9
	; Bit 7 is /EOSC, low enables oscillator
	; Bit 6 is /ESQW, low enables square wave output of the 1283
	MOV	R0,	#09H	;reg 9 is EOSC(L), ESQW(L) and months
	MOV	A,	#40H	;Enable RTC oscillator, SQW output is off
	MOVX	@R0,	A

	; Register 8 bit 7 when high, forces the INP output low always
	; This is INT0 on the DS2252T
	MOV	R0,	#08H	;Disable INP force bit.
	MOV	A,	#00H
	MOVX	@R0,	A

	MOV	R0,	#0CH	;Write any value to a watchdog alarm
	MOVX	@R0,	A	;register to clear the interrupt.

	MOV	R0,	#03H	;Write any value to a TOD alarm
	MOVX	@R0,	A	;register to clear the interrupt.

	POP	MCON		;Restore MCON settings.
DONE:
        SJMP    DONE            ;Program is complete.
        END
